/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.recommenders.internal.stacktraces.rcp.Constants;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.ModelFactory;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.Settings;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferenceInitializer
extends AbstractPreferenceInitializer {
    static boolean flagFirstAccess = true;

    public void initializeDefaultPreferences() {
        IEclipsePreferences s = DefaultScope.INSTANCE.getNode("org.eclipse.recommenders.stacktraces.rcp");
        s.put("server-url", Constants.SERVER_URL);
        s.put("name", "");
        s.put("email", "");
        s.putBoolean("skip-similar-errors", true);
        s.put("whitelisted-plugins", "org.eclipse.;com.codetrails.;");
        s.put("whitelisted-packages", "org.eclipse.;;;org.apache.;java.;javax.;javafx.;sun.;com.sun.;com.codetrails.;org.osgi.;com.google.;ch.qos.;org.slf4j.;");
        s.put("send-action", SendAction.ASK.name());
        s.putBoolean("anonymize-stacktraces", true);
        s.putBoolean("anonymize-messages", false);
    }

    public static Settings readSettings() {
        ScopedPreferenceStore s = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.stacktraces.rcp");
        Settings settings = ModelFactory.eINSTANCE.createSettings();
        settings.setName(s.getString("name"));
        settings.setEmail(s.getString("email"));
        settings.setSkipSimilarErrors(s.getBoolean("skip-similar-errors"));
        settings.setServerUrl(s.getString("server-url"));
        settings.getWhitelistedPluginIds().addAll(PreferenceInitializer.parseWhitelist(s.getString("whitelisted-plugins")));
        settings.getWhitelistedPackages().addAll(PreferenceInitializer.parseWhitelist(s.getString("whitelisted-packages")));
        settings.setAnonymizeMessages(s.getBoolean("anonymize-messages"));
        settings.setAnonymizeStrackTraceElements(s.getBoolean("anonymize-stacktraces"));
        settings.setAction(PreferenceInitializer.parseSendAction(s.getString("send-action")));
        return settings;
    }

    public static void saveSettings(Settings settings) {
        ScopedPreferenceStore s = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.stacktraces.rcp");
        s.setValue("name", settings.getName());
        s.setValue("email", settings.getEmail());
        s.setValue("skip-similar-errors", settings.isSkipSimilarErrors());
        s.setValue("anonymize-stacktraces", settings.isAnonymizeStrackTraceElements());
        s.setValue("anonymize-messages", settings.isAnonymizeMessages());
        s.setValue("send-action", settings.getAction().name());
    }

    static ArrayList<String> parseWhitelist(String s) {
        Iterable ids = Splitter.on((char)';').omitEmptyStrings().trimResults().split((CharSequence)s);
        return Lists.newArrayList((Iterable)ids);
    }

    static SendAction parseSendAction(String mode) {
        try {
            SendAction value = SendAction.valueOf((String)mode);
            if (flagFirstAccess && value == SendAction.PAUSE) {
                value = SendAction.ASK;
            }
            flagFirstAccess = false;
            return value;
        }
        catch (Exception exception) {
            return SendAction.ASK;
        }
    }
}

