/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ComboFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.recommenders.internal.stacktraces.rcp.Browsers;
import org.eclipse.recommenders.internal.stacktraces.rcp.Messages;
import org.eclipse.recommenders.internal.stacktraces.rcp.model.SendAction;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class PreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    public PreferencePage() {
        super(1);
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore((IPreferenceStore)new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.recommenders.stacktraces.rcp"));
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new StringFieldEditor("server-url", Messages.FIELD_LABEL_SERVER, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("name", Messages.FIELD_LABEL_NAME, this.getFieldEditorParent()));
        this.addField((FieldEditor)new StringFieldEditor("email", Messages.FIELD_LABEL_EMAIL, this.getFieldEditorParent()));
        this.addField((FieldEditor)new ComboFieldEditor("send-action", Messages.FIELD_LABEL_ACTION, PreferencePage.createModeLabelAndValues(), this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("anonymize-stacktraces", Messages.FIELD_LABEL_ANONYMIZE_STACKTRACES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("anonymize-messages", Messages.FIELD_LABEL_ANONYMIZE_MESSAGES, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("skip-similar-errors", Messages.FIELD_LABEL_SKIP_SIMILAR_ERRORS, this.getFieldEditorParent()));
        this.addLinks(this.getFieldEditorParent());
    }

    private void addLinks(Composite parent) {
        Composite feedback = new Composite(parent, 0);
        feedback.setLayout((Layout)new RowLayout(512));
        Link learnMoreLink = new Link(feedback, 0);
        learnMoreLink.setText(Messages.LINK_LEARN_MORE);
        learnMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser("https://docs.google.com/document/d/14vRLXcgSwy0rEbpJArsR_FftOJW1SjWUAmZuzc2O8YI/pub");
            }
        });
        Link feedbackLink = new Link(feedback, 0);
        feedbackLink.setText(Messages.LINK_PROVIDE_FEEDBACK);
        feedbackLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser("https://docs.google.com/a/codetrails.com/forms/d/1wd9AzydLv_TMa7ZBXHO7zQIhZjZCJRNMed-6J4fVNsc/viewform");
            }
        });
    }

    private static String[][] createModeLabelAndValues() {
        SendAction[] modes = SendAction.values();
        String[][] labelAndValues = new String[modes.length][2];
        int i = 0;
        while (i < modes.length) {
            SendAction mode = modes[i];
            labelAndValues[i][0] = PreferencePage.descriptionForMode(mode);
            labelAndValues[i][1] = mode.name();
            ++i;
        }
        return labelAndValues;
    }

    private static String descriptionForMode(SendAction mode) {
        switch (mode) {
            case ASK: {
                return Messages.FIELD_LABEL_ACTION_REPORT_ASK;
            }
            case IGNORE: {
                return Messages.FIELD_LABEL_ACTION_REPORT_NEVER;
            }
            case SILENT: {
                return Messages.FIELD_LABEL_ACTION_REPORT_ALWAYS;
            }
        }
        return mode.name();
    }
}

