/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.stacktraces.rcp;

import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.recommenders.internal.stacktraces.rcp.Browsers;
import org.eclipse.recommenders.internal.stacktraces.rcp.ErrorReportWizard;
import org.eclipse.recommenders.internal.stacktraces.rcp.ReportState;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;

class ThankYouDialog
extends TitleAreaDialog {
    public static Image TITLE_IMAGE = ErrorReportWizard.TITLE_IMAGE_DESC.createImage();
    private ReportState state;

    ThankYouDialog(Shell parentShell, ReportState state) {
        super(parentShell);
        this.state = state;
        this.setHelpAvailable(false);
    }

    protected boolean isResizable() {
        return true;
    }

    protected void configureShell(Shell newShell) {
        newShell.setText("Thank you!");
        super.configureShell(newShell);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle("Thank you!");
        this.setMessage("Your report has been received and is now tracked.");
        this.setTitleImage(TITLE_IMAGE);
        Label linetop = new Label(parent, 258);
        linetop.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite border = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        border.setLayout((Layout)layout);
        border.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        Label linebottom = new Label(parent, 258);
        linebottom.setLayoutData((Object)new GridData(4, 128, true, false));
        Composite container = new Composite(border, 0);
        container.setLayout((Layout)GridLayoutFactory.swtDefaults().create());
        container.setLayoutData((Object)GridDataFactory.fillDefaults().grab(true, true).create());
        StringBuilder text = new StringBuilder();
        if (this.state.isCreated()) {
            text.append("Your report is now tracked at: \n\n    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.").append("\n\n").append("To be kept informed please add yourself to cc list of the bug report.");
        } else {
            boolean needsinfo = ArrayUtils.contains((Object[])((Object[])this.state.getKeywords().or((Object)ReportState.EMPTY_STRINGS)), (Object)"needinfo");
            String status = (String)this.state.getStatus().or((Object)"UNCONFIRMED");
            if (this.equals("UNCONFIRMED", status) || this.equals("NEW", status) || this.equals("ASSIGNED", status)) {
                if (needsinfo) {
                    text.append("Your report has been matched against an existing bug report and needs further information. ").append("Please take a moment to visit the bug and see whether you can provide more details:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                } else {
                    text.append("Your report has been matched against an existing bug report. ").append("To be kept informed please add yourself to cc list of the bug report:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                }
            } else if (this.equals("RESOLVED", status) || this.equals("CLOSED", status)) {
                String resolution = (String)this.state.getResolved().or((Object)"UNKNOWN");
                if (this.equals("FIXED", resolution)) {
                    text.append("Your error has been marked as 'fixed' already. Visit the bug report for further information:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                } else if (this.equals("DUPLICATE", resolution)) {
                    text.append("Your error has been marked as 'duplicate' of another bug report. Please visit the bug report for further information:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                } else if (this.equals("MOVED", resolution)) {
                    text.append("Your error has been marked as 'moved'. Please visit the bug report for further information:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                } else if (this.equals("WORKSFORME", resolution)) {
                    text.append("The development team was not able to reproduce your error yet. Please take a moment to visit the bug and see whether you can provide more details to help us fixing it:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                } else if (this.equals("WONTFIX", resolution) || this.equals("INVALID", resolution) || this.equals("NOT_ECLIPSE", resolution)) {
                    text.append("The log event you sent has been marked as a 'normal' log message. If you think your report actually is an error, please comment on its bug report:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                } else {
                    text.append("The log event you sent has been marked as a '" + resolution + "'. If you think your report actually is an error, please comment on its bug report:\n\n").append("    <a>").append((String)this.state.getBugUrl().or((Object)"invalid server response")).append("</a>.");
                }
            } else {
                text.append("Received an unknown server response. PLease raise a bug against the current version of this error reporter.");
            }
        }
        text.append("\n\nThank you for your help.");
        Link link = new Link(container, 64);
        link.setText(text.toString());
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Browsers.openInExternalBrowser((String)ThankYouDialog.this.state.getBugUrl().get());
            }
        });
        GridDataFactory.defaultsFor((Control)link).align(4, 1).applyTo((Control)link);
        return container;
    }

    private boolean equals(String expected, String actual) {
        return StringUtils.equals((CharSequence)expected, (CharSequence)actual);
    }
}

