/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.snipmatch.rcp.WizardDescriptor;
import org.eclipse.recommenders.internal.snipmatch.rcp.WizardDescriptors;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.ISnippetRepositoryWizard;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnippetRepositoryTypeSelectionWizard
extends Wizard
implements ISnippetRepositoryWizard {
    private static final Logger LOG = LoggerFactory.getLogger(SnippetRepositoryTypeSelectionWizard.class);
    private List<WizardDescriptor> availableWizards;
    private ISnippetRepositoryWizard selectedWizard;
    private SnippetRepositoryConfiguration configurationToEdit;
    private SnippetRepositoryTypeSelectionWizardPage page;

    public SnippetRepositoryTypeSelectionWizard() {
        this.setWindowTitle(Messages.WIZARD_TYPE_SELECTION_WINDOW_TITLE);
        this.page = new SnippetRepositoryTypeSelectionWizardPage();
        this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/add_repository.png"));
        this.availableWizards = WizardDescriptors.loadAvailableWizards();
    }

    public SnippetRepositoryTypeSelectionWizard(SnippetRepositoryConfiguration configuration) {
        this.configurationToEdit = configuration;
        this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/edit_repository.png"));
        this.availableWizards = WizardDescriptors.filterApplicableWizardDescriptors(this.availableWizards, configuration);
    }

    public boolean performFinish() {
        return false;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
        this.addPage((IWizardPage)new SnippetRepositoryTypeSelectionWizardPage());
    }

    public IWizardPage getStartingPage() {
        return this.page;
    }

    public IWizardPage getNextPage(IWizardPage page) {
        this.selectedWizard.setConfiguration(this.configurationToEdit);
        return this.selectedWizard.getStartingPage();
    }

    public void updateSelectedWizard(IWizard wizard) {
        ISnippetRepositoryWizard cast = (ISnippetRepositoryWizard)Checks.cast((Object)wizard);
        if (wizard != null) {
            IWizardPage[] iWizardPageArray = wizard.getPages();
            int n = iWizardPageArray.length;
            int n2 = 0;
            while (n2 < n) {
                IWizardPage page = iWizardPageArray[n2];
                this.addPage(page);
                ++n2;
            }
        }
        this.selectedWizard = cast;
    }

    @Override
    public boolean isApplicable(SnippetRepositoryConfiguration configuration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setConfiguration(SnippetRepositoryConfiguration configuration) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SnippetRepositoryConfiguration getConfiguration() {
        return this.selectedWizard.getConfiguration();
    }

    class SnippetRepositoryTypeSelectionWizardPage
    extends WizardPage {
        private Composite container;
        private org.eclipse.swt.widgets.List lstWizards;

        protected SnippetRepositoryTypeSelectionWizardPage() {
            super(Messages.WIZARD_TYPE_SELECTION_NAME);
            this.setTitle(Messages.WIZARD_TYPE_SELECTION_TITLE);
            this.setDescription(Messages.WIZARD_TYPE_SELECTION_DESCRIPTION);
        }

        public boolean canFlipToNextPage() {
            return this.lstWizards.getSelectionIndex() != -1;
        }

        public void createControl(Composite parent) {
            this.container = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            this.container.setLayout((Layout)layout);
            GridData gd = new GridData(768);
            Label lblName = new Label(this.container, 0);
            lblName.setText(Messages.WIZARD_TYPE_SELECTION_LABEL_WIZARDS);
            lblName.setLayoutData((Object)gd);
            this.lstWizards = new org.eclipse.swt.widgets.List(this.container, 2820);
            for (WizardDescriptor wizardDescriptor : SnippetRepositoryTypeSelectionWizard.this.availableWizards) {
                this.lstWizards.add(wizardDescriptor.getName());
            }
            gd = new GridData(1808);
            this.lstWizards.setLayoutData((Object)gd);
            this.lstWizards.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    int selectionIndex = SnippetRepositoryTypeSelectionWizardPage.this.lstWizards.getSelectionIndex();
                    if (selectionIndex == -1) {
                        SnippetRepositoryTypeSelectionWizard.this.updateSelectedWizard(null);
                        SnippetRepositoryTypeSelectionWizardPage.this.setPageComplete(false);
                    } else {
                        WizardDescriptor wizardDescriptor = (WizardDescriptor)Checks.cast(SnippetRepositoryTypeSelectionWizard.this.availableWizards.get(selectionIndex));
                        SnippetRepositoryTypeSelectionWizard.this.updateSelectedWizard(wizardDescriptor.getWizard());
                        SnippetRepositoryTypeSelectionWizardPage.this.setPageComplete(true);
                    }
                }
            });
            this.lstWizards.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent e) {
                    try {
                        int index = e.y / SnippetRepositoryTypeSelectionWizardPage.this.lstWizards.getItemHeight();
                        if (index < SnippetRepositoryTypeSelectionWizardPage.this.lstWizards.getItemCount() && SnippetRepositoryTypeSelectionWizardPage.this.canFlipToNextPage()) {
                            SnippetRepositoryTypeSelectionWizardPage.this.getContainer().showPage(SnippetRepositoryTypeSelectionWizardPage.this.getNextPage());
                        }
                    }
                    catch (ArithmeticException ae) {
                        LOG.error("Open wizard on double click failed because height of list items is zero.", (Throwable)ae);
                    }
                }
            });
            this.setControl((Control)this.container);
            this.setPageComplete(false);
        }
    }
}

