/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.types.rcp;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.IProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.OverlayImageProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.ProposalTag;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.types.rcp.ITypesIndexService;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.utils.names.ITypeName;

public class TypesCompletionSessionProcessor
extends SessionProcessor {
    private static final CompletionProposal NULL_PROPOSAL = new CompletionProposal();
    public static final int BOOST = 50;
    private ImmutableSet<String> subtypes;
    private final ITypesIndexService service;
    private final OverlayImageProposalProcessor overlayDecorator;

    @Inject
    public TypesCompletionSessionProcessor(ITypesIndexService service, SharedImages images) {
        this.service = service;
        this.overlayDecorator = new OverlayImageProposalProcessor(images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.OVR_STAR), 0);
    }

    public boolean startSession(IRecommendersCompletionContext context) {
        Set expectedTypes = context.getExpectedTypeNames();
        if (expectedTypes.isEmpty()) {
            return false;
        }
        ImmutableSet.Builder b = ImmutableSet.builder();
        for (ITypeName expected : expectedTypes) {
            String oneCharPrefix = StringUtils.substring((String)context.getPrefix(), (int)0, (int)1);
            b.addAll(this.service.subtypes(expected, oneCharPrefix, context.getProject()));
        }
        this.subtypes = b.build();
        return !this.subtypes.isEmpty();
    }

    public void process(IProcessableProposal proposal) throws Exception {
        if (this.subtypes == null || this.subtypes.isEmpty()) {
            return;
        }
        CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().or((Object)NULL_PROPOSAL);
        switch (coreProposal.getKind()) {
            case 9: {
                char[] sig = coreProposal.getSignature();
                this.handleProposal(proposal, sig);
                break;
            }
            case 26: 
            case 27: {
                char[] sig = coreProposal.getDeclarationSignature();
                this.handleProposal(proposal, sig);
            }
        }
    }

    private void handleProposal(IProcessableProposal proposal, char[] signature) {
        String name = new String(signature, 1, signature.length - 2);
        if (this.subtypes.contains((Object)(name = StringUtils.substringBefore((String)name, (String)"<")))) {
            proposal.setTag((IProposalTag)ProposalTag.RECOMMENDERS_SCORE, (Object)50);
            ProposalProcessorManager mgr = proposal.getProposalProcessorManager();
            mgr.addProcessor((ProposalProcessor)new SimpleProposalProcessor(50));
            mgr.addProcessor((ProposalProcessor)this.overlayDecorator);
        }
    }
}

