/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.calls.rcp.templates;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import java.util.Arrays;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;
import org.eclipse.recommenders.utils.names.Names;
import org.eclipse.recommenders.utils.names.VmTypeName;

public class TemplateBuilder {
    private static final ToTemplateTypeNames TO_TEMPLATE_TYPE_NAMES = new ToTemplateTypeNames();
    private StringBuilder builder = new StringBuilder();
    private Multiset<String> usedVariables = HashMultiset.create();

    public TemplateBuilder append(String code) {
        this.builder.append(code);
        return this;
    }

    public Optional<String> appendCall(IMethodName method, String receiver, String ... argNames) {
        Checks.ensureIsFalse((boolean)method.isInit(), (String)"Method must not be a constructor", (Object[])new Object[0]);
        String returnId = null;
        if (!method.isVoid()) {
            ITypeName type = method.getReturnType();
            String defId = this.suggestId(method);
            this.newType(String.valueOf(defId) + "Type", type).ws();
            this.newName(defId, type).ws().eq().ws();
            returnId = "${" + defId + "}";
        }
        if (!StringUtils.isEmpty((CharSequence)receiver)) {
            this.append(receiver).dot();
        }
        this.append(method.getName()).append("(").appendParameters(method, argNames).append(")").sc();
        return Optional.fromNullable(returnId);
    }

    public TemplateBuilder appendCommand(String id, String commandId, Iterable<String> values) {
        this.builder.append("${").append(id).append(":").append(commandId).append("(");
        Joiner.on((char)',').appendTo(this.builder, values);
        this.builder.append(")}");
        return this;
    }

    public TemplateBuilder appendCommand(String id, String commandId, ITypeName ... types) {
        return this.appendCommand(id, commandId, this.toLiterals(types));
    }

    public TemplateBuilder appendCommand(String id, String commandId, String value) {
        this.builder.append("${").append(id).append(":").append(commandId).append("(").append(value).append(")}");
        return this;
    }

    public TemplateBuilder appendCommand(String id, String commandId, String ... values) {
        return this.appendCommand(id, commandId, Arrays.asList(values));
    }

    public String appendCtor(IMethodName ctor, String ... argNames) {
        Checks.ensureIsTrue((boolean)ctor.isInit());
        ITypeName type = ctor.getDeclaringType();
        String receiverId = this.suggestId(ctor);
        String receiverTypeId = String.valueOf(receiverId) + "Type";
        this.newType(receiverTypeId, type).ws().newName(receiverId, type).ws().eq().ws().new_().ws().ref(receiverTypeId).append("(");
        this.appendParameters(ctor, argNames);
        this.append(")").sc();
        return "${" + receiverId + "}";
    }

    private void appendParameter(ITypeName type, String id) {
        if (this.isVariable(id)) {
            this.ref(id);
        } else if (VmTypeName.OBJECT.equals(type)) {
            this.ref(this.suggestId(id));
        } else if (type == VmTypeName.BOOLEAN) {
            this.link(this.suggestId(id), "false", "true");
        } else if (type == VmTypeName.INT || type == VmTypeName.DOUBLE || type == VmTypeName.FLOAT || type == VmTypeName.LONG || type == VmTypeName.SHORT) {
            this.link(this.suggestId(id), "0");
        } else {
            this.var(this.suggestId(id), type);
        }
    }

    public TemplateBuilder appendParameters(IMethodName method, String ... argNames) {
        ITypeName[] argTypes = method.getParameterTypes();
        int i = 0;
        while (i < argTypes.length) {
            String arg = argNames[i];
            this.appendParameter(argTypes[i], arg);
            if (i < argTypes.length - 1) {
                this.c().ws();
            }
            ++i;
        }
        return this;
    }

    public TemplateBuilder argType(String id, String variable, int n) {
        return this.appendCommand(id, "argType", variable, String.valueOf(n));
    }

    public TemplateBuilder array() {
        return this.append("${array}");
    }

    public TemplateBuilder arrayElement() {
        return this.append("${array_element}");
    }

    public TemplateBuilder arrayType() {
        return this.append("${array_type}");
    }

    public TemplateBuilder c() {
        return this.append(",");
    }

    public TemplateBuilder collection() {
        return this.append("${collection}");
    }

    public TemplateBuilder cursor() {
        return this.append("${cursor}");
    }

    public TemplateBuilder date() {
        return this.append("${date}");
    }

    public TemplateBuilder dollar() {
        return this.append("${dollar}");
    }

    public TemplateBuilder dot() {
        return this.append(".");
    }

    public TemplateBuilder elemType(String id, String variable) {
        return this.appendCommand(id, "elemType", variable);
    }

    public TemplateBuilder enclosingMethod() {
        return this.append("${enclosing_method}");
    }

    public TemplateBuilder EnclosingMethodArguments() {
        return this.append("${enclosing_method_arguments}");
    }

    public TemplateBuilder enclosingPackage() {
        return this.append("${enclosing_package}");
    }

    public TemplateBuilder enclosingProject() {
        return this.append("${enclosing_project}");
    }

    public TemplateBuilder enclosingType() {
        return this.append("${enclosing_type}");
    }

    public TemplateBuilder eq() {
        return this.append("=");
    }

    public TemplateBuilder exceptionVariableName() {
        return this.append("${exception_variable_name}");
    }

    public TemplateBuilder field(String id, ITypeName ... types) {
        return this.appendCommand(id, "field", types);
    }

    public TemplateBuilder file() {
        return this.append("${file}");
    }

    public TemplateBuilder imports(ITypeName ... types) {
        return this.imports("", types);
    }

    public TemplateBuilder imports(String id, ITypeName ... types) {
        return this.appendCommand(id, "import", types);
    }

    public TemplateBuilder index() {
        return this.append("${index}");
    }

    public boolean isVariable(String arg) {
        return arg.startsWith("${") && arg.endsWith("}");
    }

    public TemplateBuilder iterable() {
        return this.append("${iterable}");
    }

    public TemplateBuilder iterableElement() {
        return this.append("${iterable_element}");
    }

    public TemplateBuilder iterableType() {
        return this.append("${iterable_type}");
    }

    public TemplateBuilder iterator() {
        return this.append("${iterator}");
    }

    public TemplateBuilder lineSelection() {
        return this.append("${line_selection}");
    }

    public TemplateBuilder link(String id, String ... proposals) {
        return this.appendCommand(id, "link", proposals);
    }

    public TemplateBuilder localVar(String id, ITypeName ... types) {
        return this.appendCommand(id, "localVar", types);
    }

    public TemplateBuilder new_() {
        return this.append("new");
    }

    public TemplateBuilder newName(String id, ITypeName reference) {
        return this.appendCommand(id, "newName", reference);
    }

    public TemplateBuilder newType(String id, ITypeName type) {
        return this.appendCommand(id, "newType", this.toLiteral(type));
    }

    public TemplateBuilder nl() {
        return this.append(SystemUtils.LINE_SEPARATOR);
    }

    public TemplateBuilder primaryTypeName() {
        return this.append("${primary_type_name}");
    }

    public TemplateBuilder ref(String referencedVariable) {
        this.builder.append("${").append(referencedVariable).append("}");
        return this;
    }

    public TemplateBuilder returnType() {
        return this.append("${return_type}");
    }

    public TemplateBuilder sc() {
        return this.append(";");
    }

    public String suggestId(IMethodName method) {
        String varName = null;
        if (method.isInit()) {
            varName = method.getDeclaringType().getClassName();
        } else {
            String name = method.getName();
            int start = name.startsWith("get") && !name.equals("get") ? 3 : 0;
            varName = StringUtils.substring((String)name, (int)start);
        }
        varName = varName.replaceAll("\\W", "").toLowerCase();
        return this.suggestId(varName);
    }

    public String suggestId(String varName) {
        String suffix = this.usedVariables.add((Object)varName, 1) == 0 ? "" : "" + (this.usedVariables.count((Object)varName) - 1);
        return String.valueOf(varName) + suffix;
    }

    public TemplateBuilder time() {
        return this.append("${time}");
    }

    public TemplateBuilder todo() {
        return this.append("${todo}");
    }

    public String toLiteral(ITypeName type) {
        return TO_TEMPLATE_TYPE_NAMES.apply(type);
    }

    public Iterable<String> toLiterals(ITypeName ... types) {
        return Iterables.transform(Arrays.asList(types), (Function)TO_TEMPLATE_TYPE_NAMES);
    }

    public String toString() {
        return this.builder.toString();
    }

    public TemplateBuilder user() {
        return this.append("${user}");
    }

    public TemplateBuilder var(String id, ITypeName ... types) {
        return this.appendCommand(id, "var", types);
    }

    public TemplateBuilder wordSelection() {
        return this.append("${word_selection}");
    }

    public TemplateBuilder ws() {
        return this.append(" ");
    }

    public TemplateBuilder year() {
        return this.append("${year}");
    }

    private static class ToTemplateTypeNames
    implements Function<ITypeName, String> {
        private ToTemplateTypeNames() {
        }

        public String apply(ITypeName t) {
            String res = Names.vm2srcQualifiedType((ITypeName)t);
            if (t.isArrayType()) {
                res = "'" + res + "'";
            }
            return res;
        }
    }
}

