/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.models.rcp;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableMap;
import java.io.File;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import javax.inject.Inject;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.recommenders.coordinates.DependencyInfo;
import org.eclipse.recommenders.coordinates.DependencyType;
import org.eclipse.recommenders.coordinates.IProjectCoordinateAdvisorService;
import org.eclipse.recommenders.coordinates.ProjectCoordinate;
import org.eclipse.recommenders.coordinates.rcp.DependencyInfos;
import org.eclipse.recommenders.internal.models.rcp.l10n.LogMessages;
import org.eclipse.recommenders.models.UniqueMethodName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.rcp.JavaElementResolver;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Logs;
import org.eclipse.recommenders.utils.Result;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.ITypeName;

public class ProjectCoordinateProvider
implements IProjectCoordinateProvider,
IRcpService {
    private final JavaElementResolver javaElementResolver;
    private final IProjectCoordinateAdvisorService pcAdvisorService;
    private final LoadingCache<IPackageFragmentRoot, Optional<DependencyInfo>> dependencyInfoCache;

    @Inject
    public ProjectCoordinateProvider(IProjectCoordinateAdvisorService pcAdvisorService, JavaElementResolver javaElementResolver) {
        this.pcAdvisorService = pcAdvisorService;
        this.javaElementResolver = javaElementResolver;
        this.dependencyInfoCache = this.createCache();
    }

    private LoadingCache<IPackageFragmentRoot, Optional<DependencyInfo>> createCache() {
        return CacheBuilder.newBuilder().maximumSize(200L).build((CacheLoader)new CacheLoader<IPackageFragmentRoot, Optional<DependencyInfo>>(){

            public Optional<DependencyInfo> load(IPackageFragmentRoot pfr) {
                return ProjectCoordinateProvider.this.extractDependencyInfo(pfr);
            }
        });
    }

    @Override
    public Optional<ProjectCoordinate> resolve(ITypeBinding binding) {
        if (binding == null) {
            return Optional.absent();
        }
        IType type = (IType)Checks.cast((Object)binding.getJavaElement());
        return this.resolve(type);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IType type) {
        if (type == null) {
            return Optional.absent();
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)Checks.cast((Object)type.getAncestor(3));
        return this.resolve(root);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IMethodBinding binding) {
        if (binding == null) {
            return Optional.absent();
        }
        IMethod method = (IMethod)Checks.cast((Object)binding.getJavaElement());
        return this.resolve(method);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IMethod method) {
        if (method == null) {
            return Optional.absent();
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)Checks.cast((Object)method.getAncestor(3));
        return this.resolve(root);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IPackageFragmentRoot root) {
        try {
            Optional dependencyInfo = (Optional)this.dependencyInfoCache.get((Object)root);
            if (dependencyInfo.isPresent()) {
                return this.resolve((DependencyInfo)dependencyInfo.get());
            }
            return Optional.absent();
        }
        catch (ExecutionException executionException) {
            return Optional.absent();
        }
    }

    private Optional<DependencyInfo> extractDependencyInfo(IPackageFragmentRoot root) {
        if (root == null) {
            return Optional.absent();
        }
        IJavaProject javaProject = root.getJavaProject();
        if (javaProject == null) {
            return Optional.absent();
        }
        if (!root.isArchive()) {
            return this.extractDependencyInfo(javaProject);
        }
        File location = (File)JdtUtils.getLocation((IPackageFragmentRoot)root).orNull();
        if (location == null) {
            return Optional.absent();
        }
        if (ProjectCoordinateProvider.isPartOfJRE(root, javaProject)) {
            return DependencyInfos.createJreDependencyInfo((IJavaProject)javaProject);
        }
        return Optional.of((Object)new DependencyInfo(location, DependencyType.JAR));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isPartOfJRE(IPackageFragmentRoot root, IJavaProject javaProject) {
        try {
            IClasspathEntry[] iClasspathEntryArray = javaProject.getRawClasspath();
            int n = iClasspathEntryArray.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) {
                    return false;
                }
                IClasspathEntry entry = iClasspathEntryArray[n2];
                if (entry.getEntryKind() == 5 && entry.getPath().toString().contains("org.eclipse.jdt.launching.JRE_CONTAINER")) {
                    IPackageFragmentRoot[] iPackageFragmentRootArray = javaProject.findPackageFragmentRoots(entry);
                    int n3 = iPackageFragmentRootArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IPackageFragmentRoot packageFragmentRoot = iPackageFragmentRootArray[n4];
                        if (!packageFragmentRoot.getPath().toFile().getParentFile().getName().equals("ext") && packageFragmentRoot.equals(root)) {
                            return true;
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
        }
        catch (JavaModelException e) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FAILED_TO_TRAVERSE_PROJECT_DEPENDENCIES, (Throwable)e, (Object[])new Object[]{javaProject});
        }
        return false;
    }

    @Override
    public Optional<ProjectCoordinate> resolve(IJavaProject javaProject) {
        return this.resolve((DependencyInfo)this.extractDependencyInfo(javaProject).get());
    }

    private Optional<DependencyInfo> extractDependencyInfo(IJavaProject javaProject) {
        File location = (File)JdtUtils.getLocation((IJavaProject)javaProject).orNull();
        DependencyInfo request = new DependencyInfo(location, DependencyType.PROJECT, (Map)ImmutableMap.of((Object)"PROJECT_NAME", (Object)javaProject.getElementName()));
        return Optional.of((Object)request);
    }

    @Override
    public Optional<ProjectCoordinate> resolve(DependencyInfo info) {
        return this.pcAdvisorService.suggest(info);
    }

    @Override
    public Result<ProjectCoordinate> tryResolve(DependencyInfo info) {
        return this.pcAdvisorService.trySuggest(info);
    }

    @Override
    public Optional<UniqueTypeName> toUniqueName(IType type) {
        ProjectCoordinate base = (ProjectCoordinate)this.resolve(type).orNull();
        if (base == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new UniqueTypeName(base, this.toName(type)));
    }

    @Override
    public Optional<UniqueMethodName> toUniqueName(IMethod method) {
        ProjectCoordinate base = (ProjectCoordinate)this.resolve(method).orNull();
        if (base == null) {
            return Optional.absent();
        }
        IMethodName name = (IMethodName)this.toName(method).orNull();
        if (name == null) {
            return Optional.absent();
        }
        return Optional.of((Object)new UniqueMethodName(base, name));
    }

    @Override
    public ITypeName toName(IType type) {
        return this.javaElementResolver.toRecType(type);
    }

    @Override
    public Optional<IMethodName> toName(IMethod method) {
        return this.javaElementResolver.toRecMethod(method);
    }

    @Override
    public Result<UniqueTypeName> tryToUniqueName(IType type) {
        Result<ProjectCoordinate> pc = this.tryToProjectCoordinate((IJavaElement)type);
        switch (pc.getReason()) {
            case 1: {
                return Result.absent((int)1);
            }
            case 0: {
                return Result.of((Object)new UniqueTypeName((ProjectCoordinate)pc.get(), this.toName(type)));
            }
        }
        return Result.absent();
    }

    @Override
    public Result<UniqueMethodName> tryToUniqueName(IMethod method) {
        Result<ProjectCoordinate> pc = this.tryToProjectCoordinate((IJavaElement)method);
        switch (pc.getReason()) {
            case 1: {
                return Result.absent((int)1);
            }
            case 0: {
                Optional<IMethodName> name = this.toName(method);
                if (!name.isPresent()) break;
                return Result.of((Object)new UniqueMethodName((ProjectCoordinate)pc.get(), (IMethodName)name.get()));
            }
        }
        return Result.absent();
    }

    private Result<ProjectCoordinate> tryToProjectCoordinate(IJavaElement element) {
        IPackageFragmentRoot root = (IPackageFragmentRoot)Checks.cast((Object)element.getAncestor(3));
        if (root == null) {
            return Result.absent();
        }
        try {
            DependencyInfo info = (DependencyInfo)((Optional)this.dependencyInfoCache.get((Object)root)).orNull();
            if (info == null) {
                return Result.absent();
            }
            return this.pcAdvisorService.trySuggest(info);
        }
        catch (Exception e) {
            return Result.absent((Throwable)e);
        }
    }
}

