/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.jgit.transport.CredentialItem;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.URIish;

public class ChainingCredentialsProvider
extends CredentialsProvider {
    private final List<CredentialsProvider> providers;

    public ChainingCredentialsProvider(CredentialsProvider ... providers) {
        this.providers = new ArrayList<CredentialsProvider>(Arrays.asList(providers));
    }

    public boolean isInteractive() {
        for (CredentialsProvider provider : this.providers) {
            if (!provider.isInteractive()) continue;
            return true;
        }
        return false;
    }

    public boolean supports(CredentialItem ... items) {
        for (CredentialsProvider provider : this.providers) {
            if (!provider.supports(items)) continue;
            return true;
        }
        return false;
    }

    public boolean get(URIish uri, CredentialItem ... items) {
        for (CredentialsProvider provider : this.providers) {
            if (!provider.supports(items)) continue;
            if (!provider.get(uri, items)) {
                if (!provider.isInteractive()) continue;
                return false;
            }
            if (Iterables.any(Arrays.asList(items), (Predicate)Predicates.isNull())) continue;
            return true;
        }
        return false;
    }
}

