/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.snipmatch.rcp;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import java.text.MessageFormat;
import java.util.List;
import javax.inject.Inject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.recommenders.internal.snipmatch.rcp.BranchInputValidator;
import org.eclipse.recommenders.internal.snipmatch.rcp.Repositories;
import org.eclipse.recommenders.internal.snipmatch.rcp.l10n.Messages;
import org.eclipse.recommenders.internal.snipmatch.rcp.util.RepositoryUrlValidator;
import org.eclipse.recommenders.snipmatch.ISnippetRepository;
import org.eclipse.recommenders.snipmatch.model.SnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.ISnippetRepositoryWizard;
import org.eclipse.recommenders.snipmatch.rcp.model.EclipseGitSnippetRepositoryConfiguration;
import org.eclipse.recommenders.snipmatch.rcp.model.SnipmatchRcpModelFactory;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.recommenders.utils.Urls;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class GitBasedRepositoryConfigurationWizard
extends Wizard
implements ISnippetRepositoryWizard {
    private static final List<String> REPOSITORY_OPTIONS = ImmutableList.of((Object)Messages.WIZARD_GIT_REPOSITORY_OPTION_GIT_PUSH_BRANCH_PREFIX, (Object)Messages.WIZARD_GIT_REPOSITORY_OPTION_GERRIT_PUSH_BRANCH_PREFIX, (Object)Messages.WIZARD_GIT_REPOSITORY_OPTION_OTHER_PUSH_BRANCH_PREFIX);
    @VisibleForTesting
    static final String PUSH_BRANCH_PREFIX_TEXT_KEY = "push-branch-prefix-key";
    @VisibleForTesting
    static final String PUSH_BRANCH_PREFIX_TEXT_VALUE = "push-branch-prefix-value";
    private final BranchInputValidator branchInputValidator = new BranchInputValidator();
    private final Repositories repositories;
    private GitBasedRepositoryConfigurationWizardPage page = new GitBasedRepositoryConfigurationWizardPage(Messages.WIZARD_GIT_REPOSITORY_PAGE_NAME);
    private EclipseGitSnippetRepositoryConfiguration configuration;
    private static final List<String> PUSH_BRANCH_PREFIXES = ImmutableList.of((Object)"refs/heads", (Object)"refs/for");

    @Inject
    public GitBasedRepositoryConfigurationWizard(Repositories repositories) {
        this.repositories = repositories;
        this.setWindowTitle(Messages.WIZARD_GIT_REPOSITORY_WINDOW_TITLE);
        this.page.setWizard(this);
        this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/add_git_repository.png"));
    }

    public boolean performFinish() {
        this.configuration = SnipmatchRcpModelFactory.eINSTANCE.createEclipseGitSnippetRepositoryConfiguration();
        this.configuration.setName(this.page.nameText.getText());
        this.configuration.setUrl(this.page.fetchUriText.getText());
        this.configuration.setPushUrl(this.page.pushUriText.getText());
        this.configuration.setPushBranchPrefix(this.page.pushBranchPrefixText.getText());
        return true;
    }

    @Override
    public SnippetRepositoryConfiguration getConfiguration() {
        return this.configuration;
    }

    public void addPages() {
        this.addPage((IWizardPage)this.page);
    }

    public IWizardPage getStartingPage() {
        return this.page;
    }

    public boolean canFinish() {
        return this.page.canFinish();
    }

    @Override
    public boolean isApplicable(SnippetRepositoryConfiguration configuration) {
        return configuration instanceof EclipseGitSnippetRepositoryConfiguration;
    }

    @Override
    public void setConfiguration(SnippetRepositoryConfiguration configuration) {
        this.configuration = (EclipseGitSnippetRepositoryConfiguration)Checks.cast((Object)configuration);
        if (configuration != null) {
            this.page.setImageDescriptor(AbstractUIPlugin.imageDescriptorFromPlugin((String)"org.eclipse.recommenders.snipmatch.rcp", (String)"icons/wizban/edit_git_repository.png"));
            this.page.setDescription(Messages.WIZARD_GIT_REPOSITORY_EDIT_DESCRIPTION);
        }
    }

    class GitBasedRepositoryConfigurationWizardPage
    extends WizardPage {
        private Text nameText;
        private Text fetchUriText;
        private Text pushUriText;
        private Text pushBranchPrefixText;
        private Combo pushBranchPrefixCombo;
        private String initialFetchUri;

        protected GitBasedRepositoryConfigurationWizardPage(String pageName) {
            super(pageName);
            this.setTitle(Messages.WIZARD_GIT_REPOSITORY_TITLE);
            this.setDescription(Messages.WIZARD_GIT_REPOSITORY_ADD_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            this.initializeDialogUnits((Control)parent);
            Composite container = new Composite(parent, 0);
            GridLayoutFactory.swtDefaults().numColumns(2).applyTo(container);
            Label nameLabel = new Label(container, 0);
            nameLabel.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_NAME);
            this.nameText = new Text(container, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.nameText);
            this.nameText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            this.addFetchGroup(container);
            this.addPushGroup(container);
            if (GitBasedRepositoryConfigurationWizard.this.configuration != null) {
                this.initialFetchUri = GitBasedRepositoryConfigurationWizard.this.configuration.getUrl();
                this.nameText.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getName());
                this.fetchUriText.setText(this.initialFetchUri);
                this.pushUriText.setText(GitBasedRepositoryConfigurationWizard.this.configuration.getPushUrl());
                String pushBranchPrefix = GitBasedRepositoryConfigurationWizard.this.configuration.getPushBranchPrefix();
                if (PUSH_BRANCH_PREFIXES.contains(pushBranchPrefix)) {
                    this.pushBranchPrefixCombo.select(PUSH_BRANCH_PREFIXES.indexOf(pushBranchPrefix));
                    this.pushBranchPrefixText.setText(pushBranchPrefix);
                    this.pushBranchPrefixText.setEnabled(false);
                } else {
                    this.pushBranchPrefixCombo.select(REPOSITORY_OPTIONS.indexOf(Messages.WIZARD_GIT_REPOSITORY_OPTION_OTHER_PUSH_BRANCH_PREFIX));
                    this.pushBranchPrefixText.setText(pushBranchPrefix);
                    this.pushBranchPrefixText.setEnabled(true);
                }
            } else {
                this.pushBranchPrefixCombo.select(0);
                this.pushBranchPrefixText.setText((String)PUSH_BRANCH_PREFIXES.get(0));
                this.pushBranchPrefixText.setEnabled(false);
            }
            this.nameText.forceFocus();
            this.setControl((Control)container);
            Dialog.applyDialogFont((Control)container);
            this.updatePageComplete();
        }

        private void addFetchGroup(Composite parent) {
            Group group = new Group(parent, 16);
            group.setText(Messages.WIZARD_GIT_REPOSITORY_GROUP_FETCH_SETTINGS);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)group);
            GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(2).applyTo((Composite)group);
            Label fetchUriLabel = new Label((Composite)group, 0);
            fetchUriLabel.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_FETCH_URL);
            this.fetchUriText = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fetchUriText);
            this.fetchUriText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
        }

        private void addPushGroup(Composite parent) {
            Group group = new Group(parent, 16);
            group.setText(Messages.WIZARD_GIT_REPOSITORY_GROUP_PUSH_SETTINGS);
            GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)group);
            GridLayoutFactory.swtDefaults().margins(5, 5).numColumns(4).applyTo((Composite)group);
            Label pushUriLabel = new Label((Composite)group, 0);
            pushUriLabel.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_PUSH_URL);
            this.pushUriText = new Text((Composite)group, 2052);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)this.pushUriText);
            this.pushUriText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            Label pushSettingsDescriptionLabel = new Label((Composite)group, 64);
            GridDataFactory.swtDefaults().span(4, 1).align(4, 1).grab(true, false).hint(this.convertHorizontalDLUsToPixels(300), -1).applyTo((Control)pushSettingsDescriptionLabel);
            pushSettingsDescriptionLabel.setText(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_PUSH_SETTINGS_DESCRIPTION, "format-5"));
            Label pushBranchPrefixLabel = new Label((Composite)group, 0);
            pushBranchPrefixLabel.setText(Messages.WIZARD_GIT_REPOSITORY_LABEL_PUSH_BRANCH_PREFIX);
            this.pushBranchPrefixCombo = new Combo((Composite)group, 12);
            this.pushBranchPrefixCombo.setItems(REPOSITORY_OPTIONS.toArray(new String[REPOSITORY_OPTIONS.size()]));
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pushBranchPrefixCombo);
            this.pushBranchPrefixCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    if (Messages.WIZARD_GIT_REPOSITORY_OPTION_OTHER_PUSH_BRANCH_PREFIX.equals(GitBasedRepositoryConfigurationWizardPage.this.pushBranchPrefixCombo.getText())) {
                        GitBasedRepositoryConfigurationWizardPage.this.pushBranchPrefixText.setText("");
                        GitBasedRepositoryConfigurationWizardPage.this.pushBranchPrefixText.setEnabled(true);
                    } else {
                        GitBasedRepositoryConfigurationWizardPage.this.pushBranchPrefixText.setText((String)PUSH_BRANCH_PREFIXES.get(GitBasedRepositoryConfigurationWizardPage.this.pushBranchPrefixCombo.getSelectionIndex()));
                        GitBasedRepositoryConfigurationWizardPage.this.pushBranchPrefixText.setEnabled(false);
                    }
                }
            });
            this.pushBranchPrefixText = new Text((Composite)group, 2052);
            this.pushBranchPrefixText.setData(GitBasedRepositoryConfigurationWizard.PUSH_BRANCH_PREFIX_TEXT_KEY, (Object)GitBasedRepositoryConfigurationWizard.PUSH_BRANCH_PREFIX_TEXT_VALUE);
            GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.pushBranchPrefixText);
            this.pushBranchPrefixText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    GitBasedRepositoryConfigurationWizardPage.this.updatePageComplete();
                }
            });
            Label lblBranch = new Label((Composite)group, 0);
            lblBranch.setText("/format-5");
        }

        public void updatePageComplete() {
            this.setErrorMessage(null);
            String fetchUri = this.fetchUriText.getText();
            String pushUri = this.pushUriText.getText();
            String pushBranchPrefix = this.pushBranchPrefixText.getText();
            IStatus fetchUriValidation = RepositoryUrlValidator.isValidUri(fetchUri);
            IStatus pushUriValidation = RepositoryUrlValidator.isValidUri(pushUri);
            String pushBranchPrefixValid = GitBasedRepositoryConfigurationWizard.this.branchInputValidator.isValid(pushBranchPrefix);
            if (Strings.isNullOrEmpty((String)this.nameText.getText())) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_NAME);
            } else if (!fetchUriValidation.isOK()) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_FETCH_URI, fetchUriValidation.getMessage()));
            } else if (!this.isEqualToInitialUri(fetchUri) && this.isUriAlreadyAdded(fetchUri)) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_FETCH_URI_ALREADY_ADDED);
            } else if (!pushUriValidation.isOK()) {
                this.setErrorMessage(MessageFormat.format(Messages.WIZARD_GIT_REPOSITORY_ERROR_INVALID_PUSH_URI, pushUriValidation.getMessage()));
            } else if (this.pushBranchPrefixCombo.getSelectionIndex() == -1) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_BRANCH_PREFIX_REPOSITORY);
            } else if (Strings.isNullOrEmpty((String)pushBranchPrefix)) {
                this.setErrorMessage(Messages.WIZARD_GIT_REPOSITORY_ERROR_EMPTY_BRANCH_PREFIX);
            } else if (pushBranchPrefixValid != null) {
                this.setErrorMessage(pushBranchPrefixValid);
            }
            this.setPageComplete(this.getErrorMessage() == null);
        }

        private boolean isEqualToInitialUri(String fetchUri) {
            if (this.initialFetchUri == null) {
                return false;
            }
            return Urls.mangle((String)fetchUri).equals(Urls.mangle((String)this.initialFetchUri));
        }

        private boolean isUriAlreadyAdded(String newText) {
            String mangledNewText = Urls.mangle((String)newText);
            for (ISnippetRepository repository : GitBasedRepositoryConfigurationWizard.this.repositories.getRepositories()) {
                String fetchUrl = repository.getRepositoryLocation();
                if (!Urls.mangle((String)fetchUrl).equals(mangledNewText)) continue;
                return true;
            }
            return false;
        }

        public boolean canFinish() {
            return this.isPageComplete();
        }
    }
}

