/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.statics.rcp;

import com.google.common.base.Optional;
import com.google.common.eventbus.Subscribe;
import java.io.IOException;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IModelArchiveCoordinateAdvisor;
import org.eclipse.recommenders.models.IModelRepository;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.ModelEvents;
import org.eclipse.recommenders.rcp.IRcpService;
import org.eclipse.recommenders.statics.IStaticsModel;
import org.eclipse.recommenders.statics.IStaticsModelProvider;
import org.eclipse.recommenders.statics.PoolingStaticsModelProvider;

public class RcpStaticsModelProvider
implements IStaticsModelProvider,
IRcpService {
    private final IModelRepository repository;
    private final IModelArchiveCoordinateAdvisor index;
    private final Map<String, IInputStreamTransformer> transformers;
    private IStaticsModelProvider delegate;

    @Inject
    public RcpStaticsModelProvider(IModelRepository repository, IModelArchiveCoordinateAdvisor index, Map<String, IInputStreamTransformer> transformers) {
        this.repository = repository;
        this.index = index;
        this.transformers = transformers;
    }

    @PostConstruct
    public void open() throws IOException {
        this.delegate = new PoolingStaticsModelProvider(this.repository, this.index, this.transformers);
        this.delegate.open();
    }

    @PreDestroy
    public void close() throws IOException {
        this.delegate.close();
    }

    public Optional<IStaticsModel> acquireModel(UniqueTypeName key) {
        return this.delegate.acquireModel((IUniqueName)key);
    }

    public void releaseModel(IStaticsModel value) {
        this.delegate.releaseModel((Object)value);
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryOpenedEvent e) throws IOException {
        this.open();
    }

    @Subscribe
    public void onEvent(ModelEvents.ModelRepositoryClosedEvent e) throws IOException {
        this.close();
    }
}

