/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.news.rcp;

import com.google.common.base.Preconditions;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.recommenders.internal.news.rcp.Logs;
import org.eclipse.recommenders.internal.news.rcp.l10n.LogMessages;
import org.eclipse.recommenders.internal.news.rcp.l10n.Messages;

public class FeedDescriptor
implements Comparable<FeedDescriptor> {
    private final boolean defaultRepository;
    private final String id;
    @Nullable
    private final URI uri;
    private final String name;
    private final long pollingInterval;
    @Nullable
    private final String contributedBy;
    private boolean enabled;

    public FeedDescriptor(FeedDescriptor that) {
        this(that.getId(), that.getUri().toString(), that.getName(), that.isEnabled(), that.isDefaultRepository(), that.getPollingInterval(), that.getContributedBy());
    }

    public FeedDescriptor(String uri, String name, long pollingInterval) {
        this(uri, uri, name, true, false, pollingInterval, null);
    }

    private FeedDescriptor(String id, String uri, String name, boolean enabled, boolean defaultRepository, long pollingInterval, @Nullable String contributedBy) {
        Objects.requireNonNull(id);
        Preconditions.checkArgument((boolean)FeedDescriptor.isUrlValid(uri), (Object)Messages.FEED_DESCRIPTOR_MALFORMED_URL);
        this.id = id;
        this.uri = FeedDescriptor.stringToUrl(uri);
        this.name = name;
        this.enabled = enabled;
        this.defaultRepository = defaultRepository;
        this.pollingInterval = pollingInterval;
        this.contributedBy = contributedBy;
    }

    @Nullable
    public String getContributedBy() {
        return this.contributedBy;
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    @Nullable
    public URI getUri() {
        return this.uri;
    }

    public long getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isDefaultRepository() {
        return this.defaultRepository;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        FeedDescriptor that = (FeedDescriptor)other;
        return Objects.equals(this.getId(), that.getId());
    }

    public int hashCode() {
        return Objects.hashCode(this.getId());
    }

    public static boolean isUrlValid(String url) {
        try {
            URL u = new URL(url);
            u.toURI();
        }
        catch (MalformedURLException | URISyntaxException exception) {
            return false;
        }
        return true;
    }

    @Nullable
    private static URI stringToUrl(String url) {
        try {
            return new URI(url);
        }
        catch (URISyntaxException uRISyntaxException) {
            Logs.log((Logs.ILogMessage)LogMessages.ERROR_FEED_MALFORMED_URL, url);
            return null;
        }
    }

    @Override
    public int compareTo(FeedDescriptor that) {
        return this.getName().compareTo(that.getName());
    }

    public static FeedDescriptor fromConfigurationElement(IConfigurationElement config, String contributedBy) {
        String id = config.getAttribute("id");
        String uri = config.getAttribute("uri");
        String name = config.getAttribute("name");
        String pollingIntervalAttribute = config.getAttribute("pollingInterval");
        long pollingInterval = pollingIntervalAttribute != null ? Long.parseLong(pollingIntervalAttribute) : TimeUnit.HOURS.toMinutes(8L);
        String enabledByDefaultAttribute = config.getAttribute("enabledByDefault");
        boolean enabledByDefault = enabledByDefaultAttribute != null ? Boolean.parseBoolean(enabledByDefaultAttribute) : true;
        return new FeedDescriptor(id, uri, name, enabledByDefault, true, pollingInterval, contributedBy);
    }
}

