/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.testing.jdt;

import java.util.Set;
import java.util.TreeSet;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.NodeFinder;
import org.eclipse.recommenders.utils.Pair;

public class AstUtils {
    public static final String MARKER = "$";
    public static final String MARKER_ESCAPE = "\\$";

    public static CompilationUnit createAst(String content) {
        ASTParser p = ASTParser.newParser((int)3);
        p.setKind(8);
        p.setSource(content.toCharArray());
        return (CompilationUnit)p.createAST(null);
    }

    public ASTNode findNode(CompilationUnit cu, int origSourcePosition) {
        return NodeFinder.perform((ASTNode)cu, (int)origSourcePosition, (int)1);
    }

    public static Pair<CompilationUnit, Set<Integer>> createAstWithMarkers(String content) {
        TreeSet<Integer> markers = new TreeSet<Integer>();
        int pos = 0;
        StringBuilder sb = new StringBuilder(content);
        while ((pos = sb.indexOf(MARKER, pos)) != -1) {
            sb.delete(pos, pos + 1);
            markers.add(pos);
        }
        CompilationUnit cu = AstUtils.createAst(sb.toString());
        return Pair.newPair((Object)cu, markers);
    }
}

