/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.condition;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.matcher.WithLabelMatcher;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.swt.api.Shell;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.test.utils.ShellTestUtils;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ShellIsAvailableTest {
    private Shell shell;

    @Before
    public void setUp() {
        String shellTitle = "shell";
        Display.syncExec(() -> ShellTestUtils.createShell(shellTitle));
        this.shell = new DefaultShell(shellTitle);
    }

    @After
    public void tearDown() {
        this.closeShell();
    }

    private void closeShell() {
        if (this.shell != null) {
            if (!this.shell.isDisposed()) {
                this.shell.close();
            }
            this.shell = null;
        }
    }

    @Test
    public void testClosedShell() {
        ShellIsAvailable isAvailable = new ShellIsAvailable(this.shell.getText());
        Assert.assertTrue((boolean)isAvailable.test());
        this.shell.close();
        Assert.assertFalse((boolean)isAvailable.test());
    }

    @Test
    public void testMinimizeMaximize() {
        ShellIsAvailable isAvailable = new ShellIsAvailable(this.shell.getText());
        Assert.assertTrue((boolean)isAvailable.test());
        this.shell.minimize();
        Assert.assertTrue((boolean)isAvailable.test());
        this.shell.maximize();
        Assert.assertTrue((boolean)isAvailable.test());
    }

    @Test
    public void testShellWithText() {
        ShellIsAvailable shellAvailable = new ShellIsAvailable(this.shell.getText());
        Assert.assertTrue((boolean)shellAvailable.test());
    }

    @Test
    public void testShellWithTextUnavailable() {
        this.closeShell();
        ShellIsAvailable shellAvailable = new ShellIsAvailable("shell");
        Assert.assertFalse((boolean)shellAvailable.test());
    }

    @Test
    public void testShellWithMatcher() {
        ShellIsAvailable shellAvailable = new ShellIsAvailable(new Matcher[]{new WithTextMatcher(this.shell.getText())});
        Assert.assertTrue((boolean)shellAvailable.test());
    }

    @Test
    public void testShellWithMatcherUnavailable() {
        this.closeShell();
        ShellIsAvailable shellAvailable = new ShellIsAvailable(new Matcher[]{new WithTextMatcher("shell")});
        Assert.assertFalse((boolean)shellAvailable.test());
    }

    @Test
    public void testShellWithLabelMatcherUnavailable() {
        ShellIsAvailable shellAvailable = new ShellIsAvailable(new Matcher[]{new WithLabelMatcher(this.shell.getText())});
        Assert.assertFalse((boolean)shellAvailable.test());
    }

    @Test
    public void testGetResultShell() {
        ShellIsAvailable shellAvailable = new ShellIsAvailable(this.shell);
        Assert.assertTrue((boolean)shellAvailable.test());
        Assert.assertTrue((boolean)shellAvailable.getResult().equals(this.shell.getSWTWidget()));
    }

    @Test
    public void testGetResultShellWithText() {
        ShellIsAvailable shellAvailable = new ShellIsAvailable(this.shell.getText());
        Assert.assertTrue((boolean)shellAvailable.test());
        Assert.assertTrue((boolean)shellAvailable.getResult().equals(this.shell.getSWTWidget()));
    }

    @Test
    public void testGetResultNull() {
        ShellIsAvailable shellAvailable = new ShellIsAvailable("Another Shell");
        Assert.assertFalse((boolean)shellAvailable.test());
        Assert.assertNull((Object)shellAvailable.getResult());
    }

    @Test
    public void testWaitWhile() {
        ShellIsAvailable isAvailable = new ShellIsAvailable(this.shell.getText());
        try {
            new WaitWhile((WaitCondition)isAvailable, TimePeriod.SHORT, true);
            Assert.fail((String)"Shell should have been available");
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.assertNotNull((Object)isAvailable.getResult());
        }
    }

    @Test
    public void testWaitUntil() {
        ShellIsAvailable isAvailable = new ShellIsAvailable(this.shell.getText());
        try {
            new WaitUntil((WaitCondition)isAvailable, TimePeriod.SHORT, true);
            Assert.assertNotNull((Object)isAvailable.getResult());
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {
            Assert.fail((String)"Shell should have been available");
        }
    }
}

