/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.toolitem;

import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.core.matcher.WithTooltipTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolItem;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class ToolItemTest
extends SWTLayerTestCase {
    private final String TOOLTIP = "PUSH tooltip";

    @Override
    protected void createControls(Shell shell) {
        ToolBar toolBar = new ToolBar((Composite)shell, 8519744);
        ToolItem itemPush = new ToolItem(toolBar, 8);
        itemPush.setText("PUSH text");
        itemPush.setToolTipText("PUSH tooltip");
        ToolItem itemPush2 = new ToolItem(toolBar, 8);
        itemPush2.setText("PUSH text2");
        itemPush2.setToolTipText("PUSH tooltip2");
        ToolBar toolBar2 = new ToolBar((Composite)shell, 8519744);
        ToolItem itemPush1TB2 = new ToolItem(toolBar2, 8);
        itemPush1TB2.setText("PUSH text ToolBar2");
        itemPush1TB2.setToolTipText("PUSH tooltip tb2");
        ToolItem itemPush2TB2 = new ToolItem(toolBar2, 8);
        itemPush2TB2.setText("PUSH text 2 ToolBar2");
        itemPush2TB2.setToolTipText("PUSH tooltip2 tb2");
    }

    @Test
    public void testToolItemTooltip() {
        DefaultToolItem ti = new DefaultToolItem("PUSH tooltip");
        Assert.assertTrue((String)"Item has \"PUSH tooltip\" as a tooltip", (boolean)ti.getToolTipText().equals("PUSH tooltip"));
        Assert.assertFalse((String)"Item has not \"PUSH tooltip2\" as a tooltip", (boolean)ti.getToolTipText().equals("PUSH tooltip2"));
    }

    @Test
    public void constructorWithIndex() {
        DefaultToolItem ti = new DefaultToolItem(2);
        Assert.assertTrue((String)"Item has \"PUSH tooltip tb2\" as a tooltip", (boolean)ti.getToolTipText().equals("PUSH tooltip tb2"));
        Assert.assertFalse((String)"Item has not \"PUSH tooltip2\" as a tooltip", (boolean)ti.getToolTipText().equals("PUSH tooltip2"));
    }

    @Test
    public void constructorWithRegexTest() {
        DefaultToolItem ti = new DefaultToolItem((Matcher)new WithTooltipTextMatcher((Matcher)new RegexMatcher("PUSH.*tb2")));
        Assert.assertTrue((String)"Item has \"PUSH tooltip tb2\" as a tooltip", (boolean)ti.getToolTipText().equals("PUSH tooltip tb2"));
    }

    @Test
    public void constructorWithRegexWithReferencedComposite() {
        DefaultToolItem ti = new DefaultToolItem();
        System.out.println(ti.getToolTipText());
    }

    @Test
    public void WorkbenchToolItemWithMnemonicTest() {
        new DefaultToolItem((ReferencedComposite)new WorkbenchShell(), (Matcher)new WithTooltipTextMatcher("RedDeer SWT WorkbenchToolItem with mnemonic"));
    }
}

