/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ComboRule
extends AbstractSimpleRedDeerRule {
    private String text;
    private String label;
    private int index;
    private int selection;
    private List<ReferencedComposite> composites;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Combo && event.type == 24;
    }

    public void initializeForEvent(Event event) {
        Combo c = (Combo)event.widget;
        this.widget = c;
        this.setText(c.getText());
        this.setLabel(WidgetUtils.getLabel((Control)c));
        this.setIndex(WidgetUtils.getIndex((Control)c));
        this.setSelection(c.getSelectionIndex());
        this.setComposites(RedDeerUtils.getComposites((Control)c));
        Shell s = WidgetUtils.getShell((Control)((Combo)event.widget));
        if (s != null) {
            this.setShellTitle(s.getText());
        }
    }

    public List<String> getActions() {
        StringBuilder builder = new StringBuilder();
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.label != null) {
            builder.append("new LabeledCombo(");
            builder.append(RedDeerUtils.getReferencedCompositeString(this.composites));
            builder.append("\"" + this.label + "\"");
        } else {
            builder.append("new DefaultCombo(");
            builder.append(RedDeerUtils.getReferencedCompositeString(this.composites));
            builder.append(this.index);
        }
        builder.append(")");
        if (this.selection >= 0) {
            builder.append(".setSelection(" + this.selection + ")");
        } else {
            builder.append(".setText(\"" + this.text + "\")");
        }
        toReturn.add(builder.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        if (this.label != null) {
            toReturn.add("org.eclipse.reddeer.swt.impl.combo.LabeledCombo");
        } else {
            toReturn.add("org.eclipse.reddeer.swt.impl.combo.DefaultCombo");
        }
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        return toReturn;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int getSelection() {
        return this.selection;
    }

    public void setSelection(int selection) {
        this.selection = selection;
    }

    public List<ReferencedComposite> getComposites() {
        return this.composites;
    }

    public void setComposites(List<ReferencedComposite> composites) {
        this.composites = composites;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.composites == null ? 0 : this.composites.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.label == null ? 0 : this.label.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ComboRule other = (ComboRule)((Object)obj);
        if (this.composites == null ? other.composites != null : !this.composites.equals(other.composites)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return !(this.label == null ? other.label != null : !this.label.equals(other.label));
    }
}

