/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class ListRule
extends AbstractSimpleRedDeerRule {
    private String[] selectedItems;
    private int index;
    private String label;
    private List<ReferencedComposite> composites;

    public boolean appliesTo(Event event) {
        return event.widget instanceof org.eclipse.swt.widgets.List && event.type == 13;
    }

    public void initializeForEvent(Event event) {
        this.widget = event.widget;
        this.selectedItems = ((org.eclipse.swt.widgets.List)event.widget).getSelection();
        int i = 0;
        while (i < this.selectedItems.length) {
            this.selectedItems[i] = WidgetUtils.cleanText((String)this.selectedItems[i]);
            ++i;
        }
        this.label = WidgetUtils.getLabel((Control)((org.eclipse.swt.widgets.List)event.widget));
        this.index = WidgetUtils.getIndex((Control)((org.eclipse.swt.widgets.List)event.widget));
        this.setComposites(RedDeerUtils.getComposites((Control)((org.eclipse.swt.widgets.List)event.widget)));
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder list = new StringBuilder();
        list.append("new DefaultList(");
        list.append(RedDeerUtils.getReferencedCompositeString(this.composites));
        if (this.label != null) {
            list.append("\"" + this.label + "\"");
        } else {
            list.append(this.index);
        }
        list.append(").select(");
        int i = 0;
        while (i < this.selectedItems.length) {
            list.append("\"" + this.selectedItems[i] + "\"");
            if (i + 1 < this.selectedItems.length) {
                list.append(",");
            }
            ++i;
        }
        list.append(")");
        toReturn.add(list.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("org.eclipse.reddeer.swt.impl.list.DefaultList");
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        return toReturn;
    }

    public List<ReferencedComposite> getComposites() {
        return this.composites;
    }

    public void setComposites(List<ReferencedComposite> composites) {
        this.composites = composites;
    }
}

