/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swtbot.generator.framework.WidgetUtils;
import org.eclipse.ui.forms.widgets.Hyperlink;
import org.eclipse.ui.forms.widgets.ImageHyperlink;

public class HyperlinkRule
extends AbstractSimpleRedDeerRule {
    private String text;
    private int index;
    private List<ReferencedComposite> composites;

    public boolean appliesTo(Event event) {
        return (event.widget instanceof Hyperlink || event.widget instanceof ImageHyperlink) && event.type == 3;
    }

    public void initializeForEvent(Event event) {
        this.widget = event.widget;
        this.text = ((Hyperlink)event.widget).getText();
        this.index = WidgetUtils.getIndex((Control)((Hyperlink)event.widget));
        this.composites = RedDeerUtils.getComposites((Control)((Hyperlink)event.widget));
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("new UIFormHyperlink(");
        builder.append(RedDeerUtils.getReferencedCompositeString(this.composites));
        builder.append("\"" + this.text + "\").click()");
        toReturn.add(builder.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("org.eclipse.reddeer.uiforms.hyperlink.UIFormHyperlink");
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        return toReturn;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.composites == null ? 0 : this.composites.hashCode());
        result = 31 * result + this.index;
        result = 31 * result + (this.text == null ? 0 : this.text.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        HyperlinkRule other = (HyperlinkRule)((Object)obj);
        if (this.composites == null ? other.composites != null : !this.composites.equals(other.composites)) {
            return false;
        }
        if (this.index != other.index) {
            return false;
        }
        return !(this.text == null ? other.text != null : !this.text.equals(other.text));
    }
}

