/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.view;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTestCase;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServerModule;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersView2;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesPage;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServerChildModuleTest
extends ServersViewTestCase {
    private static Server server;
    private static final String SERVER_NAME = "Server ABC";

    @BeforeClass
    public static void createProjects() {
        ServerChildModuleTest.importProjects(true);
        ServerChildModuleTest.createServer(SERVER_NAME);
        server = ServerChildModuleTest.getServersView().getServer(SERVER_NAME);
        server.start();
        ServerChildModuleTest.deployMultimodularProjectToServer();
    }

    @AfterClass
    public static void removeProjects() {
        server.stop();
        new CleanWorkspaceRequirement().fulfill();
    }

    @Test
    public void testBasicServerSubmoduleMethods() {
        ServersView2 serversView = new ServersView2();
        Server server = serversView.getServer(SERVER_NAME);
        List modules = server.getModules();
        Assert.assertTrue((String)("There should be 1 module deployed (the number of deployed modules is " + modules.size() + ")."), (modules.size() == 1 ? 1 : 0) != 0);
        Assert.assertTrue((String)("The name of deployed module should be 'server-multimodular-project-ear(server-multimodular-project)', but is '" + ((ServerModule)modules.get(0)).getLabel().getName() + "'."), (boolean)((ServerModule)modules.get(0)).getLabel().getName().equals("server-multimodular-project-ear(server-multimodular-project)"));
        ServerModule module = (ServerModule)modules.get(0);
        List childModules = module.getModules();
        Assert.assertTrue((String)("There should be 2 submodules deployed (the number of deployed submodules is " + childModules.size() + ")."), (childModules.size() == 2 ? 1 : 0) != 0);
        Assert.assertTrue((String)("The name of first deployed submodule should be 'server-multimodular-project-ejb', but is '" + ((ServerModule)childModules.get(0)).getLabel().getName() + "'."), (boolean)((ServerModule)childModules.get(0)).getLabel().getName().equals("server-multimodular-project-ejb"));
        Assert.assertTrue((String)("The name of second deployed submodule should be 'server-multimodular-project-jar', but is '" + ((ServerModule)childModules.get(1)).getLabel().getName() + "'."), (boolean)((ServerModule)childModules.get(1)).getLabel().getName().equals("server-multimodular-project-jar"));
        Assert.assertTrue((String)("The name of first deployed submodule should be 'server-multimodular-project-ejb  [Synchronized]', but is '" + ((ServerModule)childModules.get(0)).getTreeItem().getText() + "'."), (boolean)((ServerModule)childModules.get(0)).getTreeItem().getText().equals("server-multimodular-project-ejb  [Synchronized]"));
        Assert.assertTrue((String)("The name of second deployed submodule should be 'server-multimodular-project-jar  [Synchronized]', but is '" + ((ServerModule)childModules.get(1)).getTreeItem().getText() + "'."), (boolean)((ServerModule)childModules.get(1)).getTreeItem().getText().equals("server-multimodular-project-jar  [Synchronized]"));
    }

    private static void deployMultimodularProjectToServer() {
        ModifyModulesDialog dialog = server.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.addAll();
        dialog.finish();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }
}

