/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.internal.requirement.parameterized.inject;

import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.test.internal.requirement.parameterized.inject.ParameterizedStaticReqTestClazz;
import org.junit.Assert;
import org.junit.Test;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;

public class ParameterizedRequirementTest {
    @Test
    public void testStaticInject() throws InitializationError {
        this.executeTestClass(ParameterizedStaticReqTestClazz.class);
        Assert.assertNotNull((Object)ParameterizedStaticReqTestClazz.getReq());
    }

    @Test
    public void testRequirementInjectionInBefore() throws InitializationError {
        ParameterizedStaticReqTestClazz.reqInBefore = null;
        this.executeTestClass(ParameterizedStaticReqTestClazz.class);
        Assert.assertNotNull((Object)ParameterizedStaticReqTestClazz.reqInBefore);
    }

    @Test
    public void testRequirementInjectionInBeforeClass() throws InitializationError {
        ParameterizedStaticReqTestClazz.reqInBeforeClass = null;
        this.executeTestClass(ParameterizedStaticReqTestClazz.class);
        Assert.assertNotNull((Object)ParameterizedStaticReqTestClazz.reqInBeforeClass);
    }

    @Test
    public void testRequirementInjectionInParameters() throws InitializationError {
        ParameterizedStaticReqTestClazz.reqInParameters = null;
        this.executeTestClass(ParameterizedStaticReqTestClazz.class);
        Assert.assertNotNull((Object)ParameterizedStaticReqTestClazz.reqInParameters);
    }

    private void executeTestClass(Class<?> testClass) throws InitializationError {
        System.clearProperty(RedDeerProperties.CONFIG_FILE.getName());
        RunNotifier notifier = new RunNotifier();
        AllDefaultPossibilitiesBuilder builder = new AllDefaultPossibilitiesBuilder(true);
        RedDeerSuite rs = new RedDeerSuite(testClass, (RunnerBuilder)builder);
        rs.run(notifier);
    }
}

