/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.spy.view;

import org.eclipse.jface.action.Action;
import org.eclipse.reddeer.spy.view.internal.RedDeerWidgetTracker;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class RedDeerSpy {
    public static final String SPY_VIEW_HEADER = "To start/stop spying on widgets press CTRL+ALT:\n\n";
    private Action action;
    private StyledText spyOutput;
    private Runnable widgetTracker;
    private final Composite parent;
    private Widget lastWidget;

    public RedDeerSpy(Composite parent) {
        this.parent = parent;
        this.widgetTracker = new RedDeerWidgetTracker(this);
        this.createOutputText();
        this.createAction();
        this.addTrackerListener();
    }

    public StyledText getOutput() {
        return this.spyOutput;
    }

    public Action getAction() {
        return this.action;
    }

    public void setLastWidget(Widget widget) {
        this.lastWidget = widget;
    }

    public Widget getLastWidget() {
        return this.lastWidget;
    }

    public Runnable getWidgetTracker() {
        return this.widgetTracker;
    }

    private void createAction() {
        this.action = new Action("Monitor", 2){

            public void run() {
                if (RedDeerSpy.this.action.isChecked() && !RedDeerSpy.this.spyOutput.isDisposed()) {
                    Display display = RedDeerSpy.this.spyOutput.getDisplay();
                    display.timerExec(70, RedDeerSpy.this.widgetTracker);
                }
            }
        };
        this.action.setToolTipText("Enable/Disable monitoring of widgets");
        this.action.setChecked(false);
    }

    private void createOutputText() {
        this.spyOutput = new StyledText(this.parent, 778);
        this.spyOutput.setLayoutData((Object)new GridData(768, 1040, true, true));
        this.spyOutput.setText(SPY_VIEW_HEADER);
        if (this.isMac()) {
            this.spyOutput.setFont(new Font((Device)Display.getCurrent(), "Georgia", 11, 0));
        } else {
            this.spyOutput.setFont(new Font((Device)Display.getCurrent(), "Courier New", 11, 0));
        }
    }

    private void addTrackerListener() {
        this.parent.getDisplay().addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                if (event.stateMask == 262144 && event.keyCode == 65536) {
                    if (RedDeerSpy.this.action.isChecked()) {
                        RedDeerSpy.this.action.setChecked(false);
                    } else {
                        RedDeerSpy.this.action.setChecked(true);
                        RedDeerSpy.this.action.run();
                    }
                }
            }
        });
    }

    private boolean isMac() {
        String swtPlatform = SWT.getPlatform();
        return "carbon".equals(swtPlatform) || "cocoa".equals(swtPlatform);
    }
}

