/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.direct.test.preferences;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.direct.preferences.PreferencesUtil;
import org.eclipse.reddeer.eclipse.debug.ui.preferences.ConsolePreferencePage;
import org.eclipse.reddeer.eclipse.ui.ide.dialogs.IDEPerspectivesPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class PreferencesUtilTest {
    private String openAssosiatedPerspective = PreferencesUtil.getOpenAssociatedPerspective();

    @After
    public void resetPreferences() {
        PreferencesUtil.setOpenAssociatedPerspective((String)this.openAssosiatedPerspective);
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        ConsolePreferencePage consolePreferencePage = new ConsolePreferencePage((ReferencedComposite)preferenceDialog);
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)consolePreferencePage);
        consolePreferencePage.restoreDefaults();
        consolePreferencePage.apply();
        preferenceDialog.ok();
    }

    @Test
    public void autoBuildingTest() {
        ShellMenuItem menu = new ShellMenuItem(new String[]{"Project", "Build Automatically"});
        Assert.assertEquals((Object)menu.isSelected(), (Object)PreferencesUtil.isAutoBuildingOn());
        PreferencesUtil.setAutoBuildingOff();
        Assert.assertEquals((Object)menu.isSelected(), (Object)false);
        Assert.assertEquals((Object)menu.isSelected(), (Object)PreferencesUtil.isAutoBuildingOn());
        PreferencesUtil.setAutoBuildingOn();
        Assert.assertEquals((Object)menu.isSelected(), (Object)true);
        Assert.assertEquals((Object)menu.isSelected(), (Object)PreferencesUtil.isAutoBuildingOn());
    }

    @Test
    public void getOpenAssociatedPerspectiveTest() {
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        IDEPerspectivesPreferencePage perspectivesPreferencePage = new IDEPerspectivesPreferencePage((ReferencedComposite)preferencesDialog);
        preferencesDialog.open();
        preferencesDialog.select((PreferencePage)perspectivesPreferencePage);
        perspectivesPreferencePage.checkAlwaysOpenAssociatedPerspective();
        perspectivesPreferencePage.apply();
        Assert.assertEquals((Object)"always", (Object)PreferencesUtil.getOpenAssociatedPerspective());
        perspectivesPreferencePage.checkPromptOpenAssociatedPerspective();
        perspectivesPreferencePage.apply();
        Assert.assertEquals((Object)"prompt", (Object)PreferencesUtil.getOpenAssociatedPerspective());
        perspectivesPreferencePage.checkNeverOpenAssociatedPerspective();
        perspectivesPreferencePage.apply();
        Assert.assertEquals((Object)"never", (Object)PreferencesUtil.getOpenAssociatedPerspective());
        preferencesDialog.cancel();
    }

    @Test
    public void setOpenAssociatedPerspectiveTest() {
        PreferencesUtil.setOpenAssociatedPerspective((String)"always");
        WorkbenchPreferenceDialog preferencesDialog = new WorkbenchPreferenceDialog();
        IDEPerspectivesPreferencePage perspectivesPreferencePage = new IDEPerspectivesPreferencePage((ReferencedComposite)preferencesDialog);
        preferencesDialog.open();
        preferencesDialog.select((PreferencePage)perspectivesPreferencePage);
        Assert.assertTrue((boolean)perspectivesPreferencePage.isAlwaysOpenAssociatedPerspective());
        preferencesDialog.cancel();
        PreferencesUtil.setOpenAssociatedPerspective((String)"prompt");
        preferencesDialog.open();
        preferencesDialog.select((PreferencePage)perspectivesPreferencePage);
        Assert.assertTrue((boolean)perspectivesPreferencePage.isPromptOpenAssociatedPerspective());
        preferencesDialog.cancel();
        PreferencesUtil.setOpenAssociatedPerspective((String)"never");
        preferencesDialog.open();
        preferencesDialog.select((PreferencePage)perspectivesPreferencePage);
        Assert.assertTrue((boolean)perspectivesPreferencePage.isNeverOpenAssociatedPerspective());
        preferencesDialog.cancel();
    }

    @Test
    public void setOpenAssociatedPerspectiveWithIncorrectOptionTest() {
        String incorrectOption = "sometimes";
        try {
            PreferencesUtil.setOpenAssociatedPerspective((String)incorrectOption);
            Assert.fail((String)("IllegalArgumentException was expected for the option '" + incorrectOption + "'"));
        }
        catch (IllegalArgumentException e) {
            Assert.assertEquals((Object)("Expected one of [always, never, prompt] but was '" + incorrectOption + "'"), (Object)e.getMessage());
        }
    }

    @Test
    public void testLimitingConsoleOutput() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        ConsolePreferencePage consolePreferencePage = new ConsolePreferencePage((ReferencedComposite)preferenceDialog);
        preferenceDialog.select((PreferencePage)consolePreferencePage);
        Assert.assertEquals((Object)consolePreferencePage.isConsoleOutputLimited(), (Object)PreferencesUtil.isConsoleOutputLimited());
        Assert.assertEquals((long)consolePreferencePage.getConsoleOutputSize(), (long)PreferencesUtil.getConsoleOutputSize());
        preferenceDialog.cancel();
        PreferencesUtil.setConsoleOutputLimited((boolean)false);
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)consolePreferencePage);
        Assert.assertEquals((Object)false, (Object)consolePreferencePage.isConsoleOutputLimited());
        preferenceDialog.cancel();
        PreferencesUtil.setConsoleOutputSize((int)100000);
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)consolePreferencePage);
        Assert.assertEquals((Object)true, (Object)consolePreferencePage.isConsoleOutputLimited());
        Assert.assertEquals((long)100000L, (long)consolePreferencePage.getConsoleOutputSize());
        preferenceDialog.cancel();
    }

    @Test
    public void testSettingConsoleShow() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        ConsolePreferencePage consolePreferencePage = new ConsolePreferencePage((ReferencedComposite)preferenceDialog);
        preferenceDialog.select((PreferencePage)consolePreferencePage);
        Assert.assertEquals((Object)consolePreferencePage.isConsoleOpenedOnError(), (Object)PreferencesUtil.isConsoleOpenedOnError());
        Assert.assertEquals((Object)consolePreferencePage.isConsoleOpenedOnOutput(), (Object)PreferencesUtil.isConsoleOpenedOnOutput());
        preferenceDialog.cancel();
        PreferencesUtil.setConsoleOpenedOnError((boolean)true);
        PreferencesUtil.setConsoleOpenedOnOutput((boolean)false);
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)consolePreferencePage);
        Assert.assertTrue((boolean)consolePreferencePage.isConsoleOpenedOnError());
        Assert.assertFalse((boolean)consolePreferencePage.isConsoleOpenedOnOutput());
        preferenceDialog.cancel();
        PreferencesUtil.setConsoleOpenedOnError((boolean)false);
        PreferencesUtil.setConsoleOpenedOnOutput((boolean)true);
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)consolePreferencePage);
        Assert.assertFalse((boolean)consolePreferencePage.isConsoleOpenedOnError());
        Assert.assertTrue((boolean)consolePreferencePage.isConsoleOpenedOnOutput());
        preferenceDialog.cancel();
    }
}

