/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.direct.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.osgi.service.prefs.BackingStoreException;

public class Preferences {
    public static String get(String plugin, String key) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(plugin);
        return prefs.get(key, Preferences.getDefault(plugin, key));
    }

    public static String getDefault(String plugin, String key) {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(plugin);
        return prefs.get(key, null);
    }

    public static void set(String plugin, String key, String value) {
        IEclipsePreferences prefs = InstanceScope.INSTANCE.getNode(plugin);
        prefs.put(key, value);
        try {
            prefs.flush();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Cannot store preferences for " + plugin + "/" + key + "='" + value + "'", e);
        }
    }

    public static void setDefault(String plugin, String key) {
        Preferences.set(plugin, key, Preferences.getDefault(plugin, key));
    }

    public static void setDefault(String plugin) {
        String[] key = Preferences.getKeys(plugin);
        int i = 0;
        while (i < key.length) {
            Preferences.setDefault(plugin, key[i]);
            ++i;
        }
    }

    public static String[] getKeys(String plugin) {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(plugin);
        try {
            return prefs.keys();
        }
        catch (BackingStoreException e) {
            throw new RuntimeException("Cannot get keys for plugin '" + plugin + "'", e);
        }
    }
}

