/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.internal.runner;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.reddeer.junit.internal.configuration.RequirementConfigurationSet;
import org.eclipse.reddeer.junit.internal.runner.ParameterizedRequirementsRunner;
import org.eclipse.reddeer.junit.internal.runner.ParameterizedRequirementsRunnerFactory;
import org.eclipse.reddeer.junit.internal.runner.ParameterizedRunner;
import org.eclipse.reddeer.junit.internal.runner.RequirementsRunnerBuilder;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.Runner;
import org.junit.runners.Parameterized;
import org.junit.runners.ParentRunner;

public class RequirementsRunnerBuilderTest {
    private RequirementsRunnerBuilder runnerBuilder;

    @Before
    public void setup() {
        this.runnerBuilder = new RequirementsRunnerBuilder(new RequirementConfigurationSet());
    }

    @Test
    public void parameterizedRunnerTest() throws Throwable {
        Runner runner = this.runnerBuilder.runnerForClass(ParameterizedSuite.class);
        Assert.assertNotNull((Object)runner);
        Assert.assertTrue((boolean)Matchers.isA(ParameterizedRunner.class).matches((Object)runner));
        ParameterizedRunner pRunner = (ParameterizedRunner)runner;
        List<Runner> children = this.getChildren(pRunner);
        Assert.assertEquals((long)2L, (long)children.size());
        for (Runner childRunner : children) {
            Assert.assertTrue((boolean)Matchers.isA(ParameterizedRequirementsRunner.class).matches((Object)childRunner));
        }
    }

    private List<Runner> getChildren(ParameterizedRunner pRunner) throws Throwable {
        Method m = ParentRunner.class.getDeclaredMethod("getChildren", new Class[0]);
        m.setAccessible(true);
        return (List)m.invoke((Object)pRunner, new Object[0]);
    }

    @Parameterized.UseParametersRunnerFactory(value=ParameterizedRequirementsRunnerFactory.class)
    public static class ParameterizedSuite {
        @Parameterized.Parameters
        public static Collection<Object> data() {
            ArrayList<Object> c = new ArrayList<Object>();
            c.add(new Object());
            c.add(new Object());
            return c;
        }

        @Test
        public void testMethod() {
        }
    }

    public static class TestCase {
        @Test
        public void fakeTest() {
        }
    }
}

