/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.generator.framework.rules.simple;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.reddeer.swt.generator.framework.referencedComposite.ReferencedComposite;
import org.eclipse.reddeer.swt.generator.framework.rules.RedDeerUtils;
import org.eclipse.reddeer.swt.generator.framework.rules.simple.AbstractSimpleRedDeerRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swtbot.generator.framework.WidgetUtils;

public class TableRule
extends AbstractSimpleRedDeerRule {
    private int index;
    private int[] items;
    private List<String> listOfSelectedItems = new ArrayList<String>();
    private boolean check;
    private boolean checkDetail;
    private List<ReferencedComposite> composites;

    public boolean appliesTo(Event event) {
        return event.widget instanceof Table && event.type == 13;
    }

    public void initializeForEvent(Event event) {
        Table table = (Table)event.widget;
        this.widget = table;
        if (!this.tableHasDuplicates(table.getItems())) {
            TableItem[] tableItemArray = table.getSelection();
            int n = tableItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                TableItem item = tableItemArray[n2];
                this.listOfSelectedItems.add(WidgetUtils.cleanText((String)item.getText()));
                ++n2;
            }
        } else {
            this.items = table.getSelectionIndices();
        }
        this.index = WidgetUtils.getIndex((Control)table);
        Shell s = WidgetUtils.getShell((Control)((Table)event.widget));
        this.setComposites(RedDeerUtils.getComposites((Control)table));
        if (s != null) {
            this.setShellTitle(s.getText());
        }
        if (this.checkDetail = event.detail == 32) {
            this.check = table.getSelection()[0].getChecked();
        }
    }

    public List<String> getActions() {
        ArrayList<String> toReturn = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        builder.append("new DefaultTable(");
        builder.append(RedDeerUtils.getReferencedCompositeString(this.composites));
        builder.append(this.index);
        builder.append(")");
        if (!this.listOfSelectedItems.isEmpty()) {
            builder.append(".getItem(\"" + this.listOfSelectedItems.get(0) + "\")");
        } else {
            builder.append(".getItem(" + this.items[0] + ")");
        }
        if (this.checkDetail) {
            builder.append(".setChecked(" + this.check + ")");
        } else {
            builder.append(".select()");
        }
        toReturn.add(builder.toString());
        return toReturn;
    }

    public List<String> getImports() {
        ArrayList<String> toReturn = new ArrayList<String>();
        toReturn.add("org.eclipse.reddeer.swt.impl.table.DefaultTable");
        for (ReferencedComposite r : this.composites) {
            toReturn.add(r.getImport());
        }
        return toReturn;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public List<String> getListOfSelectedItems() {
        return this.listOfSelectedItems;
    }

    public void setListOfSelectedItems(List<String> listOfSelectedItems) {
        this.listOfSelectedItems = listOfSelectedItems;
    }

    private boolean tableHasDuplicates(TableItem[] tableItems) {
        HashSet<String> setOfStrings = new HashSet<String>();
        TableItem[] tableItemArray = tableItems;
        int n = tableItems.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            if (!setOfStrings.add(item.getText())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isCheck() {
        return this.check;
    }

    public void setCheck(boolean check) {
        this.check = check;
    }

    public List<ReferencedComposite> getComposites() {
        return this.composites;
    }

    public void setComposites(List<ReferencedComposite> composites) {
        this.composites = composites;
    }
}

