/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.ui.launcher;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.reddeer.common.exception.RedDeerException;
import org.eclipse.reddeer.common.properties.RedDeerProperties;

public class RedDeerLauncherProperties {
    public static final String ATTRIBUTE_PREFIX = "rd.launch.property.";
    public static final String REDDEER_PARAMETER_PREFIX = "rd.";
    public static final String REDDEER_OLD_PARAMETER_PREFIX = "reddeer.";
    private RedDeerProperties property;
    private String currentValue;
    private boolean doubleDefined = false;

    public RedDeerLauncherProperties(RedDeerProperties property) {
        this.property = property;
        this.currentValue = property.getValue();
    }

    public static List<RedDeerLauncherProperties> loadAll(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<RedDeerLauncherProperties> properties = new ArrayList<RedDeerLauncherProperties>();
        for (String key : configuration.getAttributes().keySet()) {
            if (!key.startsWith(ATTRIBUTE_PREFIX)) continue;
            String argName = key.replace(ATTRIBUTE_PREFIX, "");
            try {
                RedDeerProperties rdProperty = RedDeerLauncherProperties.getByName(argName);
                RedDeerLauncherProperties property = new RedDeerLauncherProperties(rdProperty);
                String argValue = configuration.getAttribute(key, property.getProperty().getValue());
                property.setCurrentValue(argValue);
                property.setDoubleDefined(configuration);
                properties.add(property);
            }
            catch (RedDeerException redDeerException) {}
        }
        return properties;
    }

    private static RedDeerProperties getByName(String name) {
        if (name.startsWith(REDDEER_PARAMETER_PREFIX)) {
            return RedDeerProperties.getByName((String)name);
        }
        return RedDeerProperties.getByName((String)name.replace(REDDEER_OLD_PARAMETER_PREFIX, REDDEER_PARAMETER_PREFIX));
    }

    public void load(ILaunchConfiguration config) throws CoreException {
        for (String key : config.getAttributes().keySet()) {
            if (!key.equals(this.getConfigKey())) continue;
            this.setCurrentValue(config.getAttribute(key, this.getProperty().getValue()));
            this.setDoubleDefined(config);
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy config) {
        config.removeAttribute(this.getConfigKey());
        this.setCurrentValue(this.getProperty().getDefaultValue());
    }

    public RedDeerProperties getProperty() {
        return this.property;
    }

    public String getCurrentValue() {
        return this.currentValue;
    }

    public void setCurrentValue(String newValue) {
        this.currentValue = newValue;
    }

    public boolean isDoubleDefined() {
        return this.doubleDefined;
    }

    public void save(ILaunchConfigurationWorkingCopy config) {
        config.setAttribute(this.getConfigKey(), this.getCurrentValue());
    }

    private String getConfigKey() {
        return ATTRIBUTE_PREFIX + this.getProperty().getName();
    }

    private void setDoubleDefined(ILaunchConfiguration config) throws CoreException {
        String vmLine = config.getAttribute("org.eclipse.jdt.launching.VM_ARGUMENTS", "");
        this.doubleDefined = vmLine.contains("-D" + this.getProperty().getName() + "=") || vmLine.matches(".*?-D" + this.getProperty().getName() + "\\b.*?");
    }

    static RedDeerLauncherProperties[] getInitialRedDeerLauncherProperties() {
        RedDeerProperties[] properties = RedDeerProperties.values();
        RedDeerLauncherProperties[] tabProperties = new RedDeerLauncherProperties[properties.length];
        int i = 0;
        while (i < properties.length) {
            tabProperties[i] = new RedDeerLauncherProperties(properties[i]);
            ++i;
        }
        return tabProperties;
    }
}

