/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.test.jdt.ui.TestingPreferencePage;
import org.eclipse.reddeer.jface.preference.PreferenceDialog;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class WorkbenchPreferenceDialogTest {
    private static final String DIALOG_TITLE = "Preferences";
    private static final String PAGE_NAME = "Testing preference page";
    private WorkbenchPreferenceDialog dialog;
    private PreferencePage preferencePage;

    @Before
    public void setup() {
        this.dialog = new WorkbenchPreferenceDialog();
        this.preferencePage = new PreferencePageImpl((PreferenceDialog)this.dialog);
    }

    @After
    public void cleanup() {
        ShellIsAvailable condition = new ShellIsAvailable(DIALOG_TITLE);
        if (condition.test()) {
            new DefaultShell(condition.getResult()).close();
        }
        new ShellIsAvailable(DIALOG_TITLE).test();
    }

    @Test
    public void openAndSelect() {
        this.dialog.open();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)DIALOG_TITLE));
        this.dialog.select(this.preferencePage);
        Assert.assertThat((Object)this.dialog.getPageName(), (Matcher)CoreMatchers.is((Object)PAGE_NAME));
    }

    @Test
    public void openAndSelectByPath() {
        this.dialog.open();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)DIALOG_TITLE));
        this.dialog.select(new String[]{"Testing top category", "Testing category", PAGE_NAME});
        Assert.assertThat((Object)this.dialog.getPageName(), (Matcher)CoreMatchers.is((Object)PAGE_NAME));
    }

    @Test
    public void ok() {
        this.dialog.open();
        this.dialog.select(this.preferencePage);
        this.dialog.ok();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)DIALOG_TITLE)));
        Assert.assertTrue((boolean)TestingPreferencePage.performOkCalled);
    }

    @Test
    public void cancel() {
        this.dialog.open();
        this.dialog.select(this.preferencePage);
        this.dialog.cancel();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.not((Object)DIALOG_TITLE)));
        Assert.assertTrue((boolean)TestingPreferencePage.performCancelCalled);
    }

    @Test
    public void apply() {
        this.dialog.open();
        this.dialog.select(this.preferencePage);
        this.preferencePage.apply();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)DIALOG_TITLE));
        Assert.assertThat((Object)this.preferencePage.getName(), (Matcher)CoreMatchers.is((Object)PAGE_NAME));
        Assert.assertTrue((boolean)TestingPreferencePage.performApplyCalled);
    }

    @Test
    public void restoreDefaults() {
        this.dialog.open();
        this.dialog.select(this.preferencePage);
        this.preferencePage.restoreDefaults();
        DefaultShell shell = new DefaultShell();
        Assert.assertThat((Object)shell.getText(), (Matcher)CoreMatchers.is((Object)DIALOG_TITLE));
        Assert.assertThat((Object)this.preferencePage.getName(), (Matcher)CoreMatchers.is((Object)PAGE_NAME));
        Assert.assertTrue((boolean)TestingPreferencePage.performDefaultsCalled);
    }

    class PreferencePageImpl
    extends PreferencePage {
        public PreferencePageImpl(PreferenceDialog dialog) {
            super((ReferencedComposite)dialog, new String[]{"Testing top category", "Testing category", WorkbenchPreferenceDialogTest.PAGE_NAME});
        }
    }
}

