/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.debug.ui.jres;

import java.util.stream.Collectors;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.jdt.debug.ui.jres.JREsPreferencePage;
import org.eclipse.reddeer.eclipse.jdt.ui.preferences.JREItem;
import org.eclipse.reddeer.jface.preference.PreferencePage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.property.RequirementPropertyExpandor;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class JREsPreferencePageTest {
    private WorkbenchPreferenceDialog dialog;
    private JREsPreferencePage page;

    @Before
    public void setup() {
        this.preferenceIsOpen();
    }

    @Test
    public void testAddingJRE() {
        JREsPreferencePageTest.addJRE(false);
        TableItem jre = this.getJRETableItem();
        Assert.assertFalse((boolean)jre.isChecked());
        Assert.assertFalse((boolean)this.page.getJREItem(JREsPreferencePageTest.getName()).isDefault());
    }

    @Test
    public void testAddingDefaultJRE() {
        JREsPreferencePageTest.addJRE(true);
        Assert.assertEquals((Object)(String.valueOf(JREsPreferencePageTest.getName()) + " (default)"), (Object)this.page.getJREItem(JREsPreferencePageTest.getName()).getName());
        Assert.assertTrue((boolean)this.page.getJRETableItem(JREsPreferencePageTest.getName()).isChecked());
    }

    @Test(expected=CoreLayerException.class)
    public void testJRENotFound() {
        this.page.getJREItem("RandomJRE");
    }

    @Test(expected=EclipseLayerException.class)
    public void testOneDefaultJRE() {
        for (JREItem item : this.page.getJREs()) {
            this.page.toggleJRE(item.getName(), false);
        }
    }

    @After
    public void clean() {
        this.preferenceIsOpen();
        for (JREItem item : this.page.getJREs()) {
            if (!item.getName().equals(JREsPreferencePageTest.getName())) continue;
            this.page.deleteJRE(JREsPreferencePageTest.getName());
        }
        this.dialog.cancel();
    }

    private TableItem getJRETableItem() {
        try {
            return this.page.getJRETableItem(JREsPreferencePageTest.getName());
        }
        catch (CoreLayerException coreLayerException) {
            Assert.fail((String)("Cannot select non existing JRE: " + JREsPreferencePageTest.getName() + ". Only existing JREs are: " + this.page.getJREs().stream().map(item -> item.getName()).collect(Collectors.joining(", "))));
            return null;
        }
    }

    public static void addJRE(boolean setDefault) {
        WorkbenchPreferenceDialog dialog = new WorkbenchPreferenceDialog();
        dialog.open();
        JREsPreferencePage page = new JREsPreferencePage((ReferencedComposite)dialog);
        dialog.select((PreferencePage)page);
        page.addJRE(JREsPreferencePageTest.getPath(), JREsPreferencePageTest.getName());
        if (setDefault) {
            page.setDefaultJRE(JREsPreferencePageTest.getName());
        }
    }

    public static String getName() {
        return "jre.test";
    }

    public static String getPath() {
        return RequirementPropertyExpandor.getProperty((String)"${java.home}");
    }

    private void preferenceIsOpen() {
        if (this.dialog == null || !this.dialog.isOpen()) {
            this.dialog = new WorkbenchPreferenceDialog();
            this.dialog.open();
            this.page = new JREsPreferencePage((ReferencedComposite)this.dialog);
            this.dialog.select((PreferencePage)this.page);
        }
    }
}

