/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.wizard;

import java.util.List;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersView2;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewServerWizard;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.NewServerWizardPage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class NewServerWizardPageTest {
    private static final String SERVER_NAME = "Test server";
    private static final String SERVER_PATH = "Basic";
    private ServersView2 view;
    private NewServerWizard wizard;
    private NewServerWizardPage wizardPage;

    @Before
    public void setUp() {
        this.view = new ServersView2();
        this.view.open();
        this.wizard = this.view.newServer();
        this.wizardPage = new NewServerWizardPage((ReferencedComposite)this.wizard);
    }

    @Test
    public void selectType() {
        this.wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
    }

    @Test
    public void setName() {
        this.wizardPage.selectType(new String[]{SERVER_PATH, SERVER_NAME});
        this.wizardPage.setName("ABC server");
        this.wizard.finish();
        List servers = this.view.getServers();
        Assert.assertThat((Object)servers.size(), (Matcher)CoreMatchers.is((Object)1));
        Assert.assertThat((Object)((Server)servers.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)"ABC server"));
    }

    @Test
    public void setHostName() {
        this.wizardPage.setHostName("ABC");
    }

    @After
    public void tearDown() {
        if (this.wizard != null && !this.wizard.getShell().isDisposed()) {
            this.wizard.cancel();
        }
        for (Server server : this.view.getServers()) {
            server.delete(false);
        }
    }
}

