/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.text;

import org.eclipse.reddeer.core.matcher.WithIdMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.swt.impl.button.PushButton;
import org.eclipse.reddeer.swt.impl.menu.ShellMenuItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.workbench.api.View;
import org.eclipse.reddeer.workbench.impl.view.WorkbenchView;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class DefaultTextTest {
    private View view;

    @Before
    public void closeAndOpenRedDeerSWTControls() {
        this.view = new WorkbenchView("RedDeer SWT Controls");
        if (this.view.isOpen()) {
            this.view.close();
        }
        this.view.open();
    }

    @Test
    public void defaultTextTest() {
        Assert.assertTrue((boolean)new DefaultText(0, new Matcher[0]).getText().equals("Original text"));
        DefaultText text = new DefaultText("Original text");
        Assert.assertTrue((boolean)text.getText().equals("Original text"));
        text.setText("New text");
        Assert.assertTrue((boolean)new DefaultText(0, new Matcher[0]).getText().equals("New text"));
        Assert.assertTrue((boolean)text.getText().equals("New text"));
        Assert.assertTrue((boolean)new DefaultText("New text").getText().equals("New text"));
        text.setText("Original text");
    }

    @Test
    public void testInDialog() {
        new ShellMenuItem(new String[]{"File", "New", "Other..."}).select();
        new DefaultShell("Select a wizard");
        DefaultText t = new DefaultText(0, new Matcher[0]);
        t.setText("myvalue");
        Assert.assertTrue((boolean)t.getText().equals("myvalue"));
        new PushButton("Cancel").click();
    }

    @Test
    public void testDeafaultTextWithId() {
        DefaultText text = new DefaultText((ReferencedComposite)this.view, new Matcher[]{new WithIdMatcher((Object)"text1")});
        Assert.assertEquals((Object)"Original text", (Object)text.getText());
    }
}

