/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Widget;

public class ListHandler
extends ControlHandler {
    private static ListHandler instance;

    public static ListHandler getInstance() {
        if (instance == null) {
            instance = new ListHandler();
        }
        return instance;
    }

    public String[] getItems(final List list) {
        return (String[])Display.syncExec((ResultRunnable)new ResultRunnable<String[]>(){

            public String[] run() {
                return list.getItems();
            }
        });
    }

    public void deselectAll(final List list) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                list.deselectAll();
            }
        });
    }

    public void selectAll(final List list) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if ((list.getStyle() & 2) == 0) {
                    throw new CoreLayerException("List does not support multi selection - it does not have SWT MULTI style");
                }
                list.selectAll();
                ListHandler.this.notifyWidget(13, (Widget)list);
            }
        });
    }

    public void select(final List list, final String item) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                list.deselectAll();
                int index = list.indexOf(item);
                if (index == -1) {
                    throw new CoreLayerException("Unable to select item " + item + " because it does not exist");
                }
                list.select(list.indexOf(item));
                ListHandler.this.sendClickNotifications((Widget)list);
            }
        });
    }

    public void select(final List list, final String[] items) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                list.deselectAll();
                if ((list.getStyle() & 2) != 0) {
                    String[] stringArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        int index = list.indexOf(item);
                        if (index == -1) {
                            throw new CoreLayerException("Unable to select item " + item + " because it does not exist");
                        }
                        list.select(list.indexOf(item));
                        ListHandler.this.notifyWidget(13, (Widget)list);
                        ++n2;
                    }
                } else {
                    throw new CoreLayerException("List does not support multi selection - it does not have SWT MULTI style");
                }
            }
        });
    }

    public void select(final List list, final int[] indices) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                list.deselectAll();
                if ((list.getStyle() & 2) == 0) {
                    throw new CoreLayerException("List does not support multi selection - it does not have SWT MULTI style");
                }
                list.select(indices);
                ListHandler.this.notifyWidget(13, (Widget)list);
            }
        });
    }

    public void select(final List list, final int index) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                if (list.getItemCount() - 1 < index) {
                    throw new CoreLayerException("Unable to select item with index " + index + " because it does not exist");
                }
                list.deselectAll();
                list.select(index);
                ListHandler.this.notifyWidget(13, (Widget)list);
            }
        });
    }

    public String[] getSelectedItems(final List list) {
        return (String[])Display.syncExec((ResultRunnable)new ResultRunnable<String[]>(){

            public String[] run() {
                return list.getSelection();
            }
        });
    }

    public int getSelectionIndex(final List list) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return list.getSelectionIndex();
            }
        });
    }

    public int[] getSelectionIndices(final List list) {
        Integer[] objectIndices = (Integer[])Display.syncExec((ResultRunnable)new ResultRunnable<Integer[]>(){

            public Integer[] run() {
                int[] tmpIndices = list.getSelectionIndices();
                if (tmpIndices.length == 0) {
                    return new Integer[0];
                }
                Integer[] tmpObjectIndices = new Integer[tmpIndices.length];
                int i = 0;
                while (i < tmpIndices.length) {
                    tmpObjectIndices[i] = tmpIndices[i];
                    ++i;
                }
                return tmpObjectIndices;
            }
        });
        if (objectIndices.length > 0) {
            int[] indices = new int[objectIndices.length];
            int i = 0;
            while (i < objectIndices.length) {
                indices[i] = objectIndices[i];
                ++i;
            }
            return indices;
        }
        return new int[0];
    }
}

