/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen.wizards;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.internal.junit.util.LayoutUtil;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.reddeer.codegen.builder.ClassBuilder;
import org.eclipse.reddeer.codegen.wizards.MethodStubsSelectionButtonGroup;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.osgi.framework.Bundle;

public class MethodsPage
extends NewTypeWizardPage {
    public static final String GETTER = "Getter";
    public static final String SETTER = "Setter";
    public static final String ACTION = "Action method";
    public static final String CONSTANTS = "Generate static constants";
    public static final String INCLUDE_ALL = "Include all wizard pages";
    public static final String INHERITING = "Allow inheriting (only, if are included all wizard pages)";
    private ISelection selection;
    private List<String> selectedOption;
    private ClassBuilder classBuilder;
    private Composite composite;
    private MethodStubsSelectionButtonGroup fMethodOptionStubsButtons;

    public MethodsPage(ISelection selection, ClassBuilder builder) {
        super(true, "codeGenWizardPageTwo");
        this.setTitle("Methods setup");
        this.setDescription("Specify CodeGen options (aditional methods, class properties, etc.).");
        this.setImageDescriptor(ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)"org.eclipse.reddeer.codegen"), (IPath)new Path("icons/reddeer_logo.png"), null)));
        this.selection = selection;
        this.classBuilder = builder;
        this.selectedOption = new ArrayList<String>();
        this.selectedOption.add(GETTER);
        this.selectedOption.add(SETTER);
        this.selectedOption.add(ACTION);
        this.selectedOption.add(CONSTANTS);
        this.selectedOption.add(INCLUDE_ALL);
        this.setPageComplete(false);
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        this.composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        this.composite.setLayout((Layout)layout);
        String[] optionalButtonNames = new String[]{GETTER, SETTER, ACTION, CONSTANTS, INCLUDE_ALL, INHERITING};
        this.fMethodOptionStubsButtons = new MethodStubsSelectionButtonGroup(32, optionalButtonNames, 1){

            @Override
            protected void doWidgetSelected(SelectionEvent e) {
                super.doWidgetSelected(e);
                MethodsPage.this.handleSelectedOptional(e);
            }
        };
        this.createMethodStubSelectionControls(this.composite, nColumns);
        this.fMethodOptionStubsButtons.setSelection(0, true);
        this.fMethodOptionStubsButtons.setSelection(1, true);
        this.fMethodOptionStubsButtons.setSelection(2, true);
        this.fMethodOptionStubsButtons.setSelection(3, true);
        this.fMethodOptionStubsButtons.setSelection(4, true);
        this.setControl((Control)this.composite);
        Dialog.applyDialogFont((Control)this.composite);
    }

    public ClassBuilder getClassBuilder() {
        return this.classBuilder;
    }

    private void handleSelectedOptional(SelectionEvent e) {
        String name = ((Button)e.widget).getText();
        if (this.fMethodOptionStubsButtons.isSelected(4)) {
            this.fMethodOptionStubsButtons.setEnabled(5, true);
        } else {
            this.fMethodOptionStubsButtons.setEnabled(5, false);
        }
        if (!this.selectedOption.contains(name)) {
            this.selectedOption.add(name);
            if (name.equals(INCLUDE_ALL) && this.fMethodOptionStubsButtons.isSelected(5)) {
                this.selectedOption.add(INHERITING);
            }
        } else {
            this.selectedOption.remove(name);
            if (name.equals(INCLUDE_ALL)) {
                this.selectedOption.remove(INHERITING);
            }
        }
    }

    protected void createMethodStubSelectionControls(Composite composite, int nColumns) {
        LayoutUtil.createEmptySpace((Composite)composite, (int)nColumns);
        LayoutUtil.setHorizontalSpan((Control)this.fMethodOptionStubsButtons.getSelectionButtonsGroup(composite), (int)(nColumns - 1));
    }

    public List<String> getSelectedOptional() {
        return this.selectedOption;
    }
}

