/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.jdt.ui.dialogs;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.jdt.ui.dialogs.ClassField;
import org.eclipse.reddeer.eclipse.jdt.ui.dialogs.GenerateHashCodeEqualsDialog;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassCreationWizard;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewClassWizardPage;
import org.eclipse.reddeer.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.eclipse.reddeer.workbench.impl.editor.TextEditor;
import org.eclipse.reddeer.workbench.impl.shell.WorkbenchShell;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@CleanWorkspaceRequirement.CleanWorkspace
@RunWith(value=RedDeerSuite.class)
public class GenerateHashAndEqualsTest {
    @AfterClass
    public static void deleteProject() {
        new CleanWorkspaceRequirement().fulfill();
    }

    @Test
    public void generateHashAndEquals() {
        new WorkbenchShell().maximize();
        JavaProjectWizard jp = new JavaProjectWizard();
        jp.open();
        new NewJavaProjectWizardPageOne((ReferencedComposite)jp).setProjectName("GenHashProject");
        jp.finish();
        NewClassCreationWizard jc = new NewClassCreationWizard();
        jc.open();
        NewClassWizardPage jpp = new NewClassWizardPage((ReferencedComposite)jc);
        jpp.setName("GenHash");
        jc.finish();
        TextEditor te = new TextEditor("GenHash.java");
        te.insertText(3, 0, "private String text;");
        te.save();
        GenerateHashCodeEqualsDialog gd = new GenerateHashCodeEqualsDialog();
        gd.open(false);
        Assert.assertEquals((long)1L, (long)gd.getFields().size());
        Assert.assertEquals((Object)"text", (Object)((ClassField)gd.getFields().get(0)).getFieldName());
        gd.selectAll();
        gd.ok();
        String text = te.getText();
        te.close();
        Assert.assertTrue((boolean)text.contains("equals"));
        Assert.assertTrue((boolean)text.contains("hashCode"));
    }
}

