/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.m2e.core.ui.wizard;

import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizard;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizardArchetypePage;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizardArchetypeParametersPage;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizardArtifactPage;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizardPage;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class MavenProjectWizardTest {
    @AfterClass
    public static void clean() {
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        pe.deleteAllProjects();
    }

    @Test
    public void createMavenProject() {
        MavenProjectWizard mw = new MavenProjectWizard();
        mw.open();
        mw.next();
        MavenProjectWizardArchetypePage mp1 = new MavenProjectWizardArchetypePage((ReferencedComposite)mw);
        Assert.assertEquals((Object)"All Catalogs", (Object)mp1.getArchetypeCatalog());
        mp1.selectArchetypeCatalog("Internal");
        Assert.assertEquals((Object)"Internal", (Object)mp1.getArchetypeCatalog());
        mp1.selectArchetype("org.apache.maven.archetypes", "maven-archetype-quickstart", null);
        mw.next();
        MavenProjectWizardArchetypeParametersPage mp2 = new MavenProjectWizardArchetypeParametersPage((ReferencedComposite)mw);
        mp2.setArtifactId("artifact");
        mp2.setGroupId("group");
        mp2.setVersion("1.0.0");
        Assert.assertEquals((Object)"artifact", (Object)mp2.getArtifactId());
        Assert.assertEquals((Object)"group", (Object)mp2.getGroupId());
        Assert.assertEquals((Object)"1.0.0", (Object)mp2.getVersion());
        Assert.assertEquals((Object)"group.artifact", (Object)mp2.getPackage());
        mw.finish();
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        Assert.assertTrue((boolean)pe.containsProject("artifact"));
    }

    public void createCleanMavenProject() {
        MavenProjectWizard mw = new MavenProjectWizard();
        mw.open();
        MavenProjectWizardPage mp = new MavenProjectWizardPage((ReferencedComposite)mw);
        mp.createSimpleProject(true);
        mw.next();
        MavenProjectWizardArtifactPage ma = new MavenProjectWizardArtifactPage((ReferencedComposite)mw);
        ma.setGroupId("g");
        ma.setArtifactId("a");
        mw.finish();
        ProjectExplorer pe = new ProjectExplorer();
        pe.open();
        Assert.assertTrue((boolean)pe.containsProject("a"));
    }
}

