/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.jsdt.ui.wizards;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.wst.jsdt.ui.wizards.JavaProjectWizard;
import org.eclipse.reddeer.eclipse.wst.jsdt.ui.wizards.JavaProjectWizardFirstPage;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.cleanworkspace.CleanWorkspaceRequirement;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
@CleanWorkspaceRequirement.CleanWorkspace
public class JavaProjectWizardFirstPageTest {
    public static String PROJECT_NAME = "testProject";

    @Test
    public void setName() {
        JavaProjectWizard dialog = new JavaProjectWizard();
        try {
            dialog.open();
        }
        catch (CoreLayerException exc) {
            if (!exc.getMessage().contains("matches \"JavaScript Project\"")) {
                throw exc;
            }
            return;
        }
        JavaProjectWizardFirstPage dialogPage = new JavaProjectWizardFirstPage((ReferencedComposite)dialog);
        dialogPage.setName(PROJECT_NAME);
        dialog.finish();
        Assert.assertTrue((String)("Project '" + PROJECT_NAME + "'not found"), (boolean)new ProjectExplorer().containsProject(PROJECT_NAME));
    }

    @After
    public void closeAll() {
        ShellIsAvailable shell = new ShellIsAvailable("Select a wizard");
        new WaitUntil((WaitCondition)shell, TimePeriod.SHORT, false);
        if (shell.getResult() != null) {
            new DefaultShell().close();
        }
    }
}

