/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.view;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.ModuleDelegate;

class ServerModelUtilities {
    ServerModelUtilities() {
    }

    public static IModule[] getChildModules(IModule[] module) {
        int last = module.length - 1;
        if (module[last] != null && module[last].getModuleType() != null) {
            return ServerModelUtilities.getChildModules(module[last]);
        }
        return new IModule[0];
    }

    public static IModule[] getChildModules(IModule module) {
        try {
            ModuleDelegate md = (ModuleDelegate)module.loadAdapter(ModuleDelegate.class, (IProgressMonitor)new NullProgressMonitor());
            IModule[] children = md == null ? null : md.getChildModules();
            return children == null ? new IModule[]{} : children;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static IModule[] getParentModules(IServer server, IModule module) {
        IRuntimeType rtt = ServerModelUtilities.getRuntimeType(server);
        IModule[] supported = rtt == null ? new IModule[]{} : ServerUtil.getModules((IModuleType[])rtt.getModuleTypes());
        ArrayList<IModule> list = new ArrayList<IModule>();
        int i = 0;
        while (i < supported.length) {
            IModule[] childs = ServerModelUtilities.getChildModules(supported[i]);
            if (childs != null) {
                int j = 0;
                while (j < childs.length) {
                    if (childs[j].equals(module)) {
                        list.add(supported[i]);
                    }
                    ++j;
                }
            }
            ++i;
        }
        return list.toArray(new IModule[list.size()]);
    }

    public static IRuntimeType getRuntimeType(IServer server) {
        return server == null ? null : ServerModelUtilities.getRuntimeType(server.getServerType());
    }

    public static IRuntimeType getRuntimeType(IServerType server) {
        return server == null ? null : server.getRuntimeType();
    }
}

