/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.wst.server.ui.view;

import java.util.List;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.matcher.RegexMatcher;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.exception.EclipseLayerException;
import org.eclipse.reddeer.eclipse.jdt.ui.packageview.PackageExplorerPart;
import org.eclipse.reddeer.eclipse.test.wst.server.ui.view.ServersViewTestCase;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.Server;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServerModule;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewEnums;
import org.eclipse.reddeer.eclipse.wst.server.ui.cnf.ServersViewException;
import org.eclipse.reddeer.eclipse.wst.server.ui.editor.ServerEditor;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesDialog;
import org.eclipse.reddeer.eclipse.wst.server.ui.wizard.ModifyModulesPage;
import org.eclipse.reddeer.swt.condition.ShellIsAvailable;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ServerTest
extends ServersViewTestCase {
    private static final String SERVER_1 = "Server 1";
    private static final String SERVER_2 = "Server 2";
    private static Server server1;
    private static Server server2;

    @BeforeClass
    public static void createProjects() {
        ServerTest.importProjects();
    }

    @BeforeClass
    public static void createServers() {
        ServerTest.createServer(SERVER_1);
        server1 = ServerTest.getServersView().getServer(SERVER_1);
    }

    @AfterClass
    public static void removeProjects() {
        PackageExplorerPart explorer = new PackageExplorerPart();
        explorer.open();
        for (DefaultProject project : explorer.getProjects()) {
            DeleteUtils.forceProjectDeletion((DefaultProject)project, (boolean)true);
        }
    }

    @Override
    public void tearDown() {
        if (!ServersViewEnums.ServerState.STOPPED.equals((Object)server1.getLabel().getState())) {
            server1.stop();
        }
        if (!server1.getModules().isEmpty()) {
            ModifyModulesDialog dialog = server1.addAndRemoveModules();
            ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
            page.removeAll();
            dialog.finish();
        }
        try {
            ServerTest.getServersView().getServer(SERVER_2).delete();
        }
        catch (EclipseLayerException eclipseLayerException) {}
        try {
            new WaitUntil((WaitCondition)new ShellIsAvailable("Add and Remove..."), TimePeriod.NONE);
            new DefaultShell("Add and Remove...").close();
        }
        catch (WaitTimeoutExpiredException waitTimeoutExpiredException) {}
        super.tearDown();
    }

    @Test(expected=ServersViewException.class)
    public void start() {
        server1.start();
        MatcherAssert.assertThat((Object)server1.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.STARTED));
        server1.start();
    }

    @Test(expected=ServersViewException.class)
    public void debug() {
        server1.debug();
        MatcherAssert.assertThat((Object)server1.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.DEBUGGING));
        server1.debug();
    }

    @Test(expected=ServersViewException.class)
    public void profile() {
        server1.profile();
        MatcherAssert.assertThat((Object)server1.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.PROFILING));
        server1.profile();
    }

    @Test(expected=ServersViewException.class)
    public void restart() {
        server1.debug();
        server1.restart();
        MatcherAssert.assertThat((Object)server1.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.STARTED));
        server1.stop();
        server1.restart();
    }

    @Test(expected=ServersViewException.class)
    public void restartInDebug() {
        server1.debug();
        server1.restartInDebug();
        MatcherAssert.assertThat((Object)server1.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.DEBUGGING));
        server1.stop();
        server1.restartInDebug();
    }

    @Test(expected=ServersViewException.class)
    public void restartInProfile() {
        server1.profile();
        server1.restartInProfile();
        MatcherAssert.assertThat((Object)server1.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.PROFILING));
        server1.stop();
        server1.restartInProfile();
    }

    @Test(expected=ServersViewException.class)
    public void stop() {
        server1.start();
        server1.stop();
        MatcherAssert.assertThat((Object)server1.getLabel().getState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerState.STOPPED));
        server1.stop();
        server1.stop();
    }

    @Test
    public void publish() {
        server1.publish();
        MatcherAssert.assertThat((Object)server1.getLabel().getPublishState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerPublishState.SYNCHRONIZED));
    }

    @Test
    public void clean() {
        server1.clean();
        MatcherAssert.assertThat((Object)server1.getLabel().getPublishState(), (Matcher)CoreMatchers.is((Object)ServersViewEnums.ServerPublishState.SYNCHRONIZED));
    }

    @Test
    public void delete_runningServer() {
        ServerTest.createServer(SERVER_2);
        server2 = ServerTest.getServersView().getServer(SERVER_2);
        server2.start();
        server2.delete(false);
        List servers = ServerTest.getServersView().getServers();
        MatcherAssert.assertThat((Object)servers.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)SERVER_1));
    }

    @Test
    public void delete_runningServerAndStop() {
        ServerTest.createServer(SERVER_2);
        server2 = ServerTest.getServersView().getServer(SERVER_2);
        server2.start();
        server2.delete(true);
        List servers = ServerTest.getServersView().getServers();
        MatcherAssert.assertThat((Object)servers.size(), (Matcher)CoreMatchers.is((Object)1));
        MatcherAssert.assertThat((Object)((Server)servers.get(0)).getLabel().getName(), (Matcher)CoreMatchers.is((Object)SERVER_1));
    }

    @Test
    public void openServer() {
        ServerEditor editor = server1.open();
        Assert.assertEquals((Object)server1.getLabel().getName(), (Object)editor.getTitle());
    }

    @Test
    public void addAndRemoveModule() {
        ModifyModulesDialog mmd = server1.addAndRemoveModules();
        MatcherAssert.assertThat((Object)"Add and Remove...", (Matcher)CoreMatchers.is((Object)new DefaultShell().getText()));
        mmd.cancel();
    }

    @Test
    public void getModules() {
        List modules = server1.getModules();
        MatcherAssert.assertThat((Object)modules.size(), (Matcher)CoreMatchers.is((Object)0));
    }

    @Test
    public void getModule() {
        ModifyModulesDialog dialog = server1.addAndRemoveModules();
        ModifyModulesPage page = new ModifyModulesPage((ReferencedComposite)dialog);
        page.addAll();
        dialog.finish();
        ServerModule module = server1.getModule("server-project-2");
        ServerModule module2 = server1.getModule((Matcher)new RegexMatcher(".*project-2"));
        MatcherAssert.assertThat((Object)module.getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-2"));
        MatcherAssert.assertThat((Object)module2.getLabel().getName(), (Matcher)CoreMatchers.is((Object)"server-project-2"));
    }

    @Test(expected=EclipseLayerException.class)
    public void getModule_nonExisting() {
        server1.getModule("ABC");
    }
}

