/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.ui.test.run.launchConfigurations;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.JUnitLaunchConfigurationTab;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfiguration;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.RunConfigurationsDialog;
import org.eclipse.reddeer.swt.api.TableItem;
import org.eclipse.reddeer.swt.impl.shell.DefaultShell;
import org.eclipse.reddeer.swt.impl.table.DefaultTable;
import org.eclipse.reddeer.ui.test.run.launchConfigurations.RedDeerLaunchConfiguration;
import org.eclipse.reddeer.ui.test.run.launchConfigurations.RedDeerLaunchConfigurationTab;
import org.eclipse.reddeer.ui.test.wizard.RedDeerWizardTestCase;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;

public class RedDeerRunConfigurationDialogTest
extends RedDeerWizardTestCase {
    private RunConfigurationsDialog dialog;
    private RedDeerLaunchConfiguration config;
    private static final String DIALOG_NAME = "Run Configurations";
    private static Map<String, String> rdParametersList;
    private static final Logger log;

    static {
        log = Logger.getLogger(RedDeerRunConfigurationDialogTest.class);
        rdParametersList = new HashMap<String, String>();
        rdParametersList.put("rd.pauseFailedTest", "false");
        rdParametersList.put("rd.logMessageFilter", "ALL");
        rdParametersList.put("rd.logLevel", "ALL");
        rdParametersList.put("rd.closeWelcomeScreen", "true");
        rdParametersList.put("rd.closeShells", "true");
        rdParametersList.put("rd.disableMavenIndex", "true");
        rdParametersList.put("rd.logCollectorEnabled", "true");
        rdParametersList.put("rd.maximizeWorkbench", "true");
        rdParametersList.put("rd.defaultKey", "org.eclipse.reddeer.widget.key");
        rdParametersList.put("rd.config", "");
        rdParametersList.put("rd.captureScreenshot", "true");
        rdParametersList.put("rd.relativeScreenshotDirectory", "");
        rdParametersList.put("rd.openAssociatedPerspective", "never");
        rdParametersList.put("rd.timePeriodFactor", "1.0");
    }

    @Override
    public String getWizardText() {
        return "New RedDeer Test Plugin";
    }

    @BeforeClass
    public static void setup() {
        projectName = "test.plugin";
        RedDeerRunConfigurationDialogTest.createRedDeerPluginProject();
    }

    @Before
    public void initizalizeDialog() {
        this.config = new RedDeerLaunchConfiguration();
        this.dialog = new RunConfigurationsDialog();
        this.dialog.open();
    }

    @After
    public void closeRunConfigurationDialog() {
        this.closeRunConfigDialog();
    }

    @Test
    public void testRedDeerRunConfigurationItem() {
        Assert.assertTrue((boolean)this.runConfigurationExists(() -> this.dialog.select((LaunchConfiguration)this.config)));
    }

    @Test
    public void testRedDeerRunConfigurationForClass() {
        this.addRedDeerTestClassRunConfiguration();
    }

    @Test
    public void testRedDeerLaunchConfigurationTab() {
        this.addRedDeerTestClassRunConfiguration();
        RedDeerLaunchConfigurationTab tab = new RedDeerLaunchConfigurationTab();
        tab.activate();
        Assert.assertTrue((String)"Number of RD params does not match", (tab.getTable().getItems().size() == rdParametersList.size() ? 1 : 0) != 0);
        this.checkRedDeerConfigurationPropertiesDefaults(tab.getTable());
    }

    @Test
    public void testJUnitLaunchConfigurationTab() {
        this.addRedDeerTestClassRunConfiguration();
        JUnitLaunchConfigurationTab tab = new JUnitLaunchConfigurationTab();
        tab.activate();
        MatcherAssert.assertThat((Object)tab.getProject(), (Matcher)CoreMatchers.is((Object)"test.plugin"));
        MatcherAssert.assertThat((Object)tab.getTestClass(), (Matcher)CoreMatchers.is((Object)"org.reddeer.test.RedDeerTest"));
        MatcherAssert.assertThat((Object)tab.getTestMethod(), (Matcher)CoreMatchers.is((Object)""));
        Assert.assertTrue((boolean)tab.getRunSingleTestButton().isSelected());
        MatcherAssert.assertThat((Object)tab.getTestRunner(), (Matcher)CoreMatchers.is((Object)"JUnit 4"));
    }

    private void addRedDeerTestClassRunConfiguration() {
        if (!this.dialogIsOpen()) {
            this.getProject("test.plugin").getProjectItem(EXAMPLE_TEST_CLASS_PATH).select();
            this.dialog.open();
        }
        if (!this.runConfigurationExists(() -> this.dialog.select((LaunchConfiguration)this.config, "RedDeerTest"))) {
            this.dialog.create((LaunchConfiguration)this.config, "RedDeerTest");
            this.config.apply();
        }
        Assert.assertTrue((boolean)this.runConfigurationExists(() -> this.dialog.select((LaunchConfiguration)this.config, "RedDeerTest")));
    }

    private boolean runConfigurationExists(Runnable runnable) {
        try {
            runnable.run();
        }
        catch (CoreLayerException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void closeRunConfigDialog() {
        if (this.dialogIsOpen()) {
            this.dialog.close(true);
        }
    }

    public boolean dialogIsOpen() {
        try {
            new DefaultShell(this.dialog.getTitle());
            return true;
        }
        catch (CoreLayerException coreLayerException) {
            log.info("Shell Run Configurations is not open");
            return false;
        }
    }

    private void checkRedDeerConfigurationPropertiesDefaults(DefaultTable table) {
        for (TableItem item : table.getItems()) {
            String key = item.getText(0);
            Assert.assertTrue((String)("RedDeer parameter: " + key + " was not expected"), (boolean)rdParametersList.containsKey(key));
            String value = item.getText(1);
            MatcherAssert.assertThat((String)("RedDeer parameter: " + key + " has wrong value"), (Object)rdParametersList.get(key), (Matcher)CoreMatchers.is((Object)value));
        }
    }
}

