/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.impl.ccombo;

import java.util.Arrays;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithIdMatcher;
import org.eclipse.reddeer.swt.api.CCombo;
import org.eclipse.reddeer.swt.impl.ccombo.DefaultCCombo;
import org.eclipse.reddeer.swt.impl.ccombo.LabeledCCombo;
import org.eclipse.reddeer.swt.impl.text.DefaultText;
import org.eclipse.reddeer.swt.test.SWTLayerTestCase;
import org.eclipse.reddeer.swt.test.utils.LabelTestUtils;
import org.eclipse.reddeer.swt.test.utils.TextTestUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class CComboTest
extends SWTLayerTestCase {
    private static final String COMBO_LABEL_PREFIX = "Combo";
    private static final String COMBO_ITEM_PREFIX = "Item";
    private static final String DISABLED_COMBO_LABEL = "Disabled:";

    @Override
    protected void createControls(Shell shell) {
        LabelTestUtils.createLabel((Composite)shell, "Last selection:");
        final Text selectionText = TextTestUtils.createText((Composite)shell, "No selection yet");
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                selectionText.setText(((org.eclipse.swt.custom.CCombo)e.widget).getText());
            }
        };
        int comboIndex = 0;
        while (comboIndex < 4) {
            LabelTestUtils.createLabel((Composite)shell, COMBO_LABEL_PREFIX + comboIndex);
            this.createCCombo(shell, selectionListener, comboIndex);
            ++comboIndex;
        }
        LabelTestUtils.createLabel((Composite)shell, DISABLED_COMBO_LABEL);
        org.eclipse.swt.custom.CCombo combo = new org.eclipse.swt.custom.CCombo((Composite)shell, 2048);
        combo.setEnabled(false);
    }

    private void createCCombo(Shell shell, SelectionAdapter selectionListener, int comboIndex) {
        org.eclipse.swt.custom.CCombo combo = new org.eclipse.swt.custom.CCombo((Composite)shell, 2048);
        combo.addSelectionListener((SelectionListener)selectionListener);
        String[] comboItems = this.createSampleComboItems(comboIndex);
        int itemIndex = 0;
        while (itemIndex < comboItems.length) {
            combo.add(comboItems[itemIndex]);
            ++itemIndex;
        }
        combo.setData("coolId", (Object)comboIndex);
    }

    private String[] createSampleComboItems(int comboIndex) {
        String[] items = new String[4];
        int i = 0;
        while (i < 4) {
            items[i] = COMBO_ITEM_PREFIX + comboIndex + i;
            ++i;
        }
        return items;
    }

    @Test
    public void findByIndex() {
        int index = 1;
        DefaultCCombo ccombo = new DefaultCCombo(index, new Matcher[0]);
        ccombo.setSelection(index);
        String ccomboText = ccombo.getText();
        String expectedCComboText = COMBO_ITEM_PREFIX + index + index;
        Assert.assertTrue((String)("CCombo text is " + ccomboText + "\nbut expected CCombo text is " + expectedCComboText), (boolean)ccomboText.equals(expectedCComboText));
    }

    @Test
    public void findById() {
        int index = 1;
        DefaultCCombo ccombo = new DefaultCCombo(new Matcher[]{new WithIdMatcher("coolId", (Object)index)});
        ccombo.setSelection(index);
        String ccomboText = ccombo.getText();
        String expectedCComboText = COMBO_ITEM_PREFIX + index + index;
        Assert.assertTrue((String)("CCombo text is " + ccomboText + "\nbut expected CCombo text is " + expectedCComboText), (boolean)ccomboText.equals(expectedCComboText));
    }

    @Test
    public void findByName() {
        int index = 3;
        LabeledCCombo ccombo = new LabeledCCombo(COMBO_LABEL_PREFIX + index);
        ccombo.setSelection(index);
        String ccomboText = ccombo.getText();
        String expectedCComboText = COMBO_ITEM_PREFIX + index + index;
        Assert.assertTrue((String)("CCombo text is " + ccomboText + "\nbut expected CCombo text is " + expectedCComboText), (boolean)ccomboText.equals(expectedCComboText));
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByIndex() {
        new DefaultCCombo(5, new Matcher[0]);
    }

    @Test(expected=CoreLayerException.class)
    public void findNonExistingByLabel() {
        new LabeledCCombo("NON_EXISTING_LABEL_&*");
    }

    @Test
    public void enabled() {
        DefaultCCombo ccombo = new DefaultCCombo(1, new Matcher[0]);
        Assert.assertTrue((String)"CCombo is not enabled", (boolean)ccombo.isEnabled());
        ccombo = new LabeledCCombo(DISABLED_COMBO_LABEL);
        Assert.assertFalse((String)"CCombo is enabled", (boolean)ccombo.isEnabled());
    }

    @Test
    public void selectionByIndex() {
        int comboIndex = 1;
        int itemIndex = 2;
        LabeledCCombo ccombo = new LabeledCCombo(COMBO_LABEL_PREFIX + comboIndex);
        ccombo.setSelection(itemIndex);
        String ccomboText = ccombo.getText();
        String expectedCComboText = COMBO_ITEM_PREFIX + comboIndex + itemIndex;
        Assert.assertTrue((String)("CCombo text is " + ccomboText + "\nbut expected CCombo text is " + expectedCComboText), (boolean)ccomboText.equals(expectedCComboText));
        String selectionText = new DefaultText(0, new Matcher[0]).getText();
        String expectedSelection = COMBO_ITEM_PREFIX + comboIndex + itemIndex;
        Assert.assertTrue((String)("Selection text is " + selectionText + "\nbut expected selection text is " + expectedSelection), (boolean)selectionText.equals(expectedSelection));
    }

    @Test
    public void selectionByItem() {
        int ccomboIndex = 2;
        int itemIndex = 3;
        LabeledCCombo ccombo = new LabeledCCombo(COMBO_LABEL_PREFIX + ccomboIndex);
        ccombo.setSelection(COMBO_ITEM_PREFIX + ccomboIndex + itemIndex);
        String ccomboText = ccombo.getText();
        String expectedCComboText = COMBO_ITEM_PREFIX + ccomboIndex + itemIndex;
        Assert.assertTrue((String)("Combo text is " + ccomboText + "\nbut expected Combo text is " + expectedCComboText), (boolean)ccomboText.equals(expectedCComboText));
        String selectionText = new DefaultText(0, new Matcher[0]).getText();
        String expectedSelection = COMBO_ITEM_PREFIX + ccomboIndex + itemIndex;
        Assert.assertTrue((String)("Selection text is " + selectionText + "\nbut expected selection text is " + expectedSelection), (boolean)selectionText.equals(expectedSelection));
    }

    @Test
    public void getAllItems() {
        int ccomboIndex = 0;
        while (ccomboIndex < 4) {
            Object[] expectedItems = this.createSampleComboItems(ccomboIndex);
            CCombo[] ccombos = new CCombo[]{new LabeledCCombo(COMBO_LABEL_PREFIX + ccomboIndex), new DefaultCCombo(ccomboIndex, new Matcher[0])};
            int i = 0;
            while (i < ccombos.length) {
                Object[] items = ccombos[i].getItems().toArray(new String[ccombos[i].getItems().size()]);
                Assert.assertTrue((String)("Retrieved items are: " + Arrays.toString(items) + "\nbut expected are: " + Arrays.toString(expectedItems) + "\nItems were retrieved from " + ccombos[i].getClass()), (boolean)Arrays.equals(expectedItems, items));
                ++i;
            }
            ++ccomboIndex;
        }
    }
}

