/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.core.handler;

import java.util.Arrays;
import org.eclipse.reddeer.common.logging.Logger;
import org.eclipse.reddeer.common.util.Display;
import org.eclipse.reddeer.common.util.ResultRunnable;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.handler.ControlHandler;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.graphics.Point;

public class CComboHandler
extends ControlHandler {
    private static final Logger log = Logger.getLogger(CComboHandler.class);
    private static CComboHandler instance;

    public static CComboHandler getInstance() {
        if (instance == null) {
            instance = new CComboHandler();
        }
        return instance;
    }

    public String[] getItems(final CCombo ccombo) {
        return (String[])Display.syncExec((ResultRunnable)new ResultRunnable<String[]>(){

            public String[] run() {
                return ccombo.getItems();
            }
        });
    }

    public void setSelection(final CCombo ccombo, final int index) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                int itemsLength = CComboHandler.this.getItems(ccombo).length;
                if (index >= itemsLength) {
                    log.error("CCombo does not have " + index + 1 + "items!");
                    log.info("CCombo has " + itemsLength + " items");
                    throw new CoreLayerException("Nonexisted item in combo was requested");
                }
                ccombo.select(index);
            }
        });
    }

    public void setSelection(final CCombo ccombo, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                String[] items = CComboHandler.this.getItems(ccombo);
                int index = Arrays.asList(items).indexOf(text);
                if (index == -1) {
                    log.error("'" + text + "' is not contained in custom combo items");
                    log.info("Items present in custom combo:");
                    int i = 0;
                    String[] stringArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String item = stringArray[n2];
                        log.info("    " + item + "(index " + i);
                        ++i;
                        ++n2;
                    }
                    throw new CoreLayerException("Nonexisting item in custom combo with text \"" + text + "\" was requested");
                }
                ccombo.select(index);
            }
        });
    }

    public String getSelection(final CCombo ccombo) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                Point selection = ccombo.getSelection();
                String comboText = ccombo.getText();
                String selectionText = "";
                if (selection.y > selection.x) {
                    selectionText = comboText.substring(selection.x, selection.y);
                }
                return selectionText;
            }
        });
    }

    public int getSelectionIndex(final CCombo ccombo) {
        return (Integer)Display.syncExec((ResultRunnable)new ResultRunnable<Integer>(){

            public Integer run() {
                return ccombo.getSelectionIndex();
            }
        });
    }

    public String getText(final CCombo ccombo) {
        return (String)Display.syncExec((ResultRunnable)new ResultRunnable<String>(){

            public String run() {
                return ccombo.getText();
            }
        });
    }

    public void setText(final CCombo ccombo, final String text) {
        Display.syncExec((Runnable)new Runnable(){

            @Override
            public void run() {
                ccombo.setText(text);
            }
        });
    }
}

