/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.requirement.matcher;

import org.eclipse.reddeer.common.matcher.VersionComparator;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class VersionComparatorTest {
    private static VersionComparator comparator;
    private static String V1_0;
    private static String V1_0_0;
    private static String V1_0_1;
    private static String V1_1;
    private static String V1_1_0;
    private static String V1_1_1;

    static {
        V1_0 = "1.0";
        V1_0_0 = "1.0.0";
        V1_0_1 = "1.0.1";
        V1_1 = "1.1";
        V1_1_0 = "1.1.0";
        V1_1_1 = "1.1.1";
    }

    @BeforeClass
    public static void setup() {
        comparator = new VersionComparator();
    }

    @Test
    public void testVersions1() {
        Assert.assertTrue((comparator.compare(V1_0, V1_1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersions2() {
        Assert.assertTrue((comparator.compare(V1_1_0, V1_1) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersions3a() {
        Assert.assertTrue((comparator.compare(V1_0, V1_0_1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersions3b() {
        Assert.assertTrue((comparator.compare(V1_0_1, V1_0) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersions4() {
        Assert.assertTrue((comparator.compare(V1_0, V1_0_0) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersions5() {
        Assert.assertTrue((comparator.compare(V1_1_1, V1_0_0) > 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersions6() {
        Assert.assertTrue((comparator.compare(V1_0_0, V1_0_1) < 0 ? 1 : 0) != 0);
    }

    @Test
    public void testVersions7() {
        Assert.assertTrue((comparator.compare(V1_0_1, V1_0_1) == 0 ? 1 : 0) != 0);
    }
}

