/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.logparser.dialogs;

import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.reddeer.logparser.model.ParseRule;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ParseRuleDialog
extends Dialog {
    private ParseRule parseRule;
    private List<ParseRule> existingParseRules;
    private boolean isAdd = false;
    private Text txName;
    private Text txDescritpion;
    private Text txIncludeRegex;
    private Text txExcludeRegex;
    private Text txIndent;
    private Text txPrefix;
    private Text txDisplayLinesBefore;
    private Text txDisplaylinesAfter;

    public ParseRuleDialog(Shell parentShell, ParseRule parseRule, List<ParseRule> existingParseRules) {
        super(parentShell);
        this.parseRule = parseRule != null ? parseRule : new ParseRule();
        this.existingParseRules = existingParseRules;
        this.isAdd = parseRule.getName() == null || parseRule.getName().length() == 0;
        this.setShellStyle(this.getShellStyle() | 0x4F0);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(2, false));
        GridData textLayoutData = new GridData(768);
        textLayoutData.widthHint = 350;
        Label label = new Label(container, 0);
        label.setText("Name:");
        this.txName = new Text(container, 2048);
        this.txName.setLayoutData((Object)textLayoutData);
        this.txName.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ParseRuleDialog.this.setOKButtonSensitivity();
            }
        });
        label = new Label(container, 2048);
        label.setLayoutData((Object)new GridData(16384, 128, false, false));
        label.setText("Description:");
        this.txDescritpion = new Text(container, 2818);
        GridData multiTextLayoutData = new GridData(768);
        multiTextLayoutData.widthHint = textLayoutData.widthHint;
        multiTextLayoutData.heightHint = 70;
        this.txDescritpion.setLayoutData((Object)multiTextLayoutData);
        label = new Label(container, 0);
        label.setText("Include Regex:");
        this.txIncludeRegex = new Text(container, 2048);
        this.txIncludeRegex.setLayoutData((Object)textLayoutData);
        label = new Label(container, 0);
        label.setText("Exlude Regex:");
        this.txExcludeRegex = new Text(container, 2048);
        this.txExcludeRegex.setLayoutData((Object)textLayoutData);
        label = new Label(container, 0);
        label.setText("Indent:");
        this.txIndent = new Text(container, 2048);
        this.txIndent.setLayoutData((Object)textLayoutData);
        label = new Label(container, 0);
        label.setText("Prefix:");
        this.txPrefix = new Text(container, 2048);
        this.txPrefix.setLayoutData((Object)textLayoutData);
        label = new Label(container, 0);
        label.setText("Display lines before:");
        this.txDisplayLinesBefore = new Text(container, 2048);
        this.txDisplayLinesBefore.setLayoutData((Object)textLayoutData);
        label = new Label(container, 0);
        label.setText("Display lines after:");
        this.txDisplaylinesAfter = new Text(container, 2048);
        this.txDisplaylinesAfter.setLayoutData((Object)textLayoutData);
        this.initContent();
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(String.valueOf(this.isAdd ? "Add" : "Edit") + " Parse Rule");
    }

    public ParseRule getParseRule() {
        return this.parseRule;
    }

    protected void okPressed() {
        this.saveContent();
        super.okPressed();
    }

    private void initContent() {
        this.txName.setText(this.parseRule.getName());
        this.txDescritpion.setText(this.parseRule.getDescription());
        this.txIncludeRegex.setText(this.parseRule.getIncludeRegex());
        this.txExcludeRegex.setText(this.parseRule.getExcludeRegex());
        this.txIndent.setText(String.valueOf(this.parseRule.getIndent()));
        this.txPrefix.setText(this.parseRule.getPrefix());
        this.txDisplayLinesBefore.setText(String.valueOf(this.parseRule.getDisplayLinesBefore()));
        this.txDisplaylinesAfter.setText(String.valueOf(this.parseRule.getDisplaylinesAfter()));
    }

    private void setOKButtonSensitivity() {
        boolean enabled = false;
        enabled = this.isAdd ? this.txName.getText().length() > 0 && this.isNameUnique(this.txName.getText()) : this.txName.getText().length() > 0 && (this.txName.getText().equalsIgnoreCase(this.parseRule.getName()) || this.isNameUnique(this.txName.getText()));
        Button btnOK = this.getButton(0);
        if (btnOK != null) {
            btnOK.setEnabled(enabled);
        }
    }

    private boolean isNameUnique(String name) {
        boolean isUnique = true;
        if (this.existingParseRules != null && this.existingParseRules.size() > 0) {
            Iterator<ParseRule> itParseRule = this.existingParseRules.iterator();
            while (isUnique && itParseRule.hasNext()) {
                if (!name.equalsIgnoreCase(itParseRule.next().getName())) continue;
                isUnique = false;
            }
        }
        return isUnique;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.setOKButtonSensitivity();
    }

    private void saveContent() {
        this.parseRule.setName(this.txName.getText());
        this.parseRule.setDescription(this.txDescritpion.getText());
        this.parseRule.setIncludeRegex(this.txIncludeRegex.getText());
        this.parseRule.setExcludeRegex(this.txExcludeRegex.getText());
        this.parseRule.setIndent(Integer.parseInt(this.txIndent.getText()));
        this.parseRule.setPrefix(this.txPrefix.getText());
        this.parseRule.setDisplayLinesBefore(Integer.parseInt(this.txDisplayLinesBefore.getText()));
        this.parseRule.setDisplaylinesAfter(Integer.parseInt(this.txDisplaylinesAfter.getText()));
    }
}

