/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.requirements.test.preferences;

import java.lang.annotation.Annotation;
import org.eclipse.reddeer.direct.preferences.Preferences;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.preferences.OomphRecorderRequirement;
import org.eclipse.reddeer.swt.impl.toolbar.DefaultToolBar;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=RedDeerSuite.class)
public class OomphRecorderRequirementTest {
    private static final String OOMPH_PLUGIN_ID = "org.eclipse.oomph.setup.ui";
    private static final String OOMPH_ENABLE_RECORDER_KEY = "enable.preference.recorder";
    private OomphRecorderRequirement requirementEnabled;
    private OomphRecorderRequirement requirementDisabled;

    @Before
    public void setupRequirement() {
        this.requirementEnabled = new OomphRecorderRequirement();
        this.requirementEnabled.setDeclaration((Annotation)this.createDisableOomphRecorderInstance(true));
        this.requirementDisabled = new OomphRecorderRequirement();
        this.requirementDisabled.setDeclaration((Annotation)this.createDisableOomphRecorderInstance(false));
    }

    public DefaultToolBar getPreferencesToolBar() {
        return new DefaultToolBar();
    }

    @Test
    public void testEnableOomphRecorder() {
        this.requirementEnabled.fulfill();
        String actualValue = Preferences.get((String)OOMPH_PLUGIN_ID, (String)OOMPH_ENABLE_RECORDER_KEY);
        Assert.assertTrue((boolean)Boolean.valueOf(actualValue));
    }

    @Test
    public void testDisableOomphRecorder() {
        this.requirementDisabled.fulfill();
        String actualValue = Preferences.get((String)OOMPH_PLUGIN_ID, (String)OOMPH_ENABLE_RECORDER_KEY);
        Assert.assertFalse((boolean)Boolean.valueOf(actualValue));
    }

    private OomphRecorderRequirement.DisableOomphRecorder createDisableOomphRecorderInstance(final boolean enabled) {
        return new OomphRecorderRequirement.DisableOomphRecorder(){

            public Class<? extends Annotation> annotationType() {
                return OomphRecorderRequirement.DisableOomphRecorder.class;
            }

            public boolean enabled() {
                return enabled;
            }
        };
    }
}

