/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.swt.test.condition;

import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.exception.WaitTimeoutExpiredException;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.swt.condition.TreeContainsItem;
import org.eclipse.reddeer.swt.impl.tree.DefaultTree;
import org.eclipse.reddeer.swt.test.impl.tree.AbstractTreeTest;
import org.eclipse.swt.widgets.Tree;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TreeContainsItemTest
extends AbstractTreeTest {
    protected org.eclipse.reddeer.swt.api.Tree tree;

    @Before
    public void initTree() {
        this.tree = new DefaultTree();
        this.createTreeItems((Tree)this.tree.getSWTWidget());
    }

    @Test
    public void testTreeContainsItem() {
        TreeContainsItem cond = new TreeContainsItem(this.tree, new String[]{"A"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT, false);
        Assert.assertNotNull((Object)cond.getResult());
        cond = new TreeContainsItem(new String[]{"A"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT, false);
        Assert.assertNotNull((Object)cond.getResult());
    }

    @Test
    public void testTreeContainsItemNested() {
        TreeContainsItem cond = new TreeContainsItem(this.tree, new String[]{"A", "AA", "AAA"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT, false);
        Assert.assertNotNull((Object)cond.getResult());
        cond = new TreeContainsItem(new String[]{"A", "AA", "AAA"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT, false);
        Assert.assertNotNull((Object)cond.getResult());
    }

    @Test
    public void testTreeContainsItemInvalid() {
        TreeContainsItem cond = new TreeContainsItem(this.tree, new String[]{"XXX"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT, false);
        Assert.assertNull((Object)cond.getResult());
        cond = new TreeContainsItem(new String[]{"XXX"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT, false);
        Assert.assertNull((Object)cond.getResult());
    }

    @Test
    public void testTreeContainsItemSecondLevel() {
        TreeContainsItem cond = new TreeContainsItem(this.tree, new String[]{"AA"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT, false);
        Assert.assertNull((Object)cond.getResult());
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void testTreeContainsItemFailNested() {
        TreeContainsItem cond = new TreeContainsItem(this.tree, new String[]{"A", "XXX"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT);
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void testTreeContainsItemNullTree() {
        TreeContainsItem cond = new TreeContainsItem(null, new String[]{"A", "AA", "AAA"});
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT);
    }

    @Test(expected=WaitTimeoutExpiredException.class)
    public void testTreeContainsItemNullItem() {
        TreeContainsItem cond = new TreeContainsItem(this.tree, null);
        new WaitUntil((WaitCondition)cond, TimePeriod.SHORT);
    }
}

