/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.eclipse.test.debug.core;

import java.io.File;
import org.eclipse.reddeer.common.condition.WaitCondition;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.eclipse.reddeer.common.wait.WaitUntil;
import org.eclipse.reddeer.common.wait.WaitWhile;
import org.eclipse.reddeer.core.exception.CoreLayerException;
import org.eclipse.reddeer.core.matcher.WithTextMatcher;
import org.eclipse.reddeer.core.reference.ReferencedComposite;
import org.eclipse.reddeer.eclipse.condition.LaunchIsSuspended;
import org.eclipse.reddeer.eclipse.condition.LaunchIsTerminated;
import org.eclipse.reddeer.eclipse.core.resources.DefaultProject;
import org.eclipse.reddeer.eclipse.core.resources.ProjectItem;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.JUnitLaunchConfiguration;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.LaunchConfiguration;
import org.eclipse.reddeer.eclipse.debug.ui.launchConfigurations.RunConfigurationsDialog;
import org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints.Breakpoint;
import org.eclipse.reddeer.eclipse.debug.ui.views.breakpoints.BreakpointsView;
import org.eclipse.reddeer.eclipse.debug.ui.views.launch.LaunchView;
import org.eclipse.reddeer.eclipse.debug.ui.views.launch.ResumeButton;
import org.eclipse.reddeer.eclipse.debug.ui.views.variables.VariablesView;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizard;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizardArchetypePage;
import org.eclipse.reddeer.eclipse.m2e.core.ui.wizard.MavenProjectWizardArchetypeParametersPage;
import org.eclipse.reddeer.eclipse.test.Activator;
import org.eclipse.reddeer.eclipse.ui.navigator.resources.ProjectExplorer;
import org.eclipse.reddeer.eclipse.ui.perspectives.DebugPerspective;
import org.eclipse.reddeer.eclipse.utils.DeleteUtils;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.requirements.openperspective.OpenPerspectiveRequirement;
import org.eclipse.reddeer.workbench.core.condition.JobIsRunning;
import org.hamcrest.Matcher;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;

@OpenPerspectiveRequirement.OpenPerspective(value=DebugPerspective.class)
@RunWith(value=RedDeerSuite.class)
public class DebuggerTest {
    private static final String JAVA_FILE_NAME = "AppTest";
    public static final File BREAKPOINST_FILE = new File(Activator.getTestResourcesLocation(DebuggerTest.class), "AppTest.bkpt");
    public static final String BREAKPOINT_1 = "AppTest [line: 28]";
    public static final String BREAKPOINT_2 = "AppTest [line: 36]";
    public static final ProjectExplorer projectExplorer = new ProjectExplorer();

    @BeforeClass
    public static void createProject() {
        projectExplorer.open();
        projectExplorer.deleteAllProjects(true);
        MavenProjectWizard mavenProjectWizard = new MavenProjectWizard();
        mavenProjectWizard.open();
        mavenProjectWizard.next();
        MavenProjectWizardArchetypePage archetypePage = new MavenProjectWizardArchetypePage((ReferencedComposite)mavenProjectWizard);
        new WaitUntil((WaitCondition)new JobIsRunning((Matcher)new WithTextMatcher("Retrieving archetypes:")), TimePeriod.MEDIUM, false);
        new WaitWhile((WaitCondition)new JobIsRunning((Matcher)new WithTextMatcher("Retrieving archetypes:")), TimePeriod.DEFAULT);
        archetypePage.setFilterText("org.apache.maven");
        archetypePage.toggleShowLatestArchetypeVersion(false);
        new WaitWhile((WaitCondition)new JobIsRunning((Matcher)new WithTextMatcher("Retrieving archetypes:")), TimePeriod.DEFAULT);
        archetypePage.selectArchetype("org.apache.maven.archetypes", "maven-archetype-quickstart", "1.1");
        mavenProjectWizard.next();
        MavenProjectWizardArchetypeParametersPage artifactPage = new MavenProjectWizardArchetypeParametersPage((ReferencedComposite)mavenProjectWizard);
        artifactPage.setGroupId("com.example");
        artifactPage.setArtifactId("debugger");
        mavenProjectWizard.finish(TimePeriod.VERY_LONG);
    }

    @Before
    public void setUp() {
        this.removeAllBreakpoints();
    }

    @After
    public void tearDown() {
        this.removeAllBreakpoints();
        this.removeJunitLaunchConfiguration();
    }

    private void removeJunitLaunchConfiguration() {
        RunConfigurationsDialog launchConf = new RunConfigurationsDialog();
        launchConf.open();
        try {
            launchConf.delete((LaunchConfiguration)new JUnitLaunchConfiguration(), JAVA_FILE_NAME);
        }
        catch (CoreLayerException coreLayerException) {}
        launchConf.close();
    }

    @AfterClass
    public static void removeProjext() {
        projectExplorer.open();
        DeleteUtils.forceProjectDeletion((DefaultProject)projectExplorer.getProject("debugger"), (boolean)true);
    }

    private void removeAllBreakpoints() {
        new BreakpointsView().removeAllBreakpoints();
    }

    @Test
    public void debugWithBothBreakpointsTest() {
        BreakpointsView breakpointsView = new BreakpointsView();
        breakpointsView.importBreakpoints(BREAKPOINST_FILE.getAbsolutePath());
        Assert.assertTrue((boolean)breakpointsView.isBreakpointAvailable(BREAKPOINT_1));
        Assert.assertTrue((boolean)breakpointsView.isBreakpointAvailable(BREAKPOINT_2));
        projectExplorer.open();
        DefaultProject appProject = new ProjectExplorer().getProject("debugger");
        ProjectItem appTest = appProject.getProjectItem(new String[]{"src/test/java", "com.example.debugger", "AppTest.java"});
        appTest.debugAs("JUnit Test");
        new WaitUntil((WaitCondition)new LaunchIsSuspended());
        Assert.assertEquals((Object)"AppTest.suite() line: 28", (Object)new LaunchView().getSelectedText());
        new ResumeButton().click();
        new WaitUntil((WaitCondition)new LaunchIsSuspended());
        Assert.assertEquals((Object)"AppTest.testApp() line: 36", (Object)new LaunchView().getSelectedText());
        new LaunchView().getSelectedItem().select();
        Assert.assertEquals((Object)"testApp(com.example.debugger.AppTest)", (Object)new VariablesView().getValue(new String[]{"this"}));
        new ResumeButton().click();
        new WaitUntil((WaitCondition)new LaunchIsTerminated());
    }

    @Test
    public void debugWithFirstBreakpointTest() {
        BreakpointsView breakpointsView = new BreakpointsView();
        breakpointsView.importBreakpoints(BREAKPOINST_FILE.getAbsolutePath());
        Assert.assertTrue((boolean)breakpointsView.isBreakpointAvailable(BREAKPOINT_1));
        Assert.assertTrue((boolean)breakpointsView.isBreakpointAvailable(BREAKPOINT_2));
        Breakpoint breakpoint = breakpointsView.getBreakpoint(BREAKPOINT_2);
        breakpoint.remove();
        Assert.assertFalse((boolean)breakpointsView.isBreakpointAvailable(BREAKPOINT_2));
        projectExplorer.open();
        DefaultProject appProject = new ProjectExplorer().getProject("debugger");
        ProjectItem appTest = appProject.getProjectItem(new String[]{"src/test/java", "com.example.debugger", "AppTest.java"});
        appTest.debugAs("JUnit Test");
        new WaitUntil((WaitCondition)new LaunchIsSuspended());
        Assert.assertEquals((Object)"AppTest.suite() line: 28", (Object)new LaunchView().getSelectedText());
        new ResumeButton().click();
        new WaitUntil((WaitCondition)new LaunchIsTerminated());
    }

    @Test
    public void debugWithSecondBreakpointTest() {
        BreakpointsView breakpointsView = new BreakpointsView();
        breakpointsView.importBreakpoints(BREAKPOINST_FILE.getAbsolutePath());
        Assert.assertTrue((boolean)breakpointsView.isBreakpointAvailable(BREAKPOINT_1));
        Assert.assertTrue((boolean)breakpointsView.isBreakpointAvailable(BREAKPOINT_2));
        Breakpoint breakpoint = breakpointsView.getBreakpoint(BREAKPOINT_1);
        breakpoint.disable();
        Assert.assertFalse((boolean)breakpoint.isEnabled());
        Assert.assertFalse((boolean)breakpoint.isChecked());
        projectExplorer.open();
        DefaultProject appProject = new ProjectExplorer().getProject("debugger");
        ProjectItem appTest = appProject.getProjectItem(new String[]{"src/test/java", "com.example.debugger", "AppTest.java"});
        appTest.debugAs("JUnit Test");
        new WaitUntil((WaitCondition)new LaunchIsSuspended());
        Assert.assertEquals((Object)"AppTest.testApp() line: 36", (Object)new LaunchView().getSelectedText());
        new ResumeButton().click();
        new WaitUntil((WaitCondition)new LaunchIsTerminated());
    }
}

