/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.common.test.wait;

import org.eclipse.reddeer.common.properties.RedDeerProperties;
import org.eclipse.reddeer.common.wait.TimePeriod;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class TimePeriodTest {
    private static String timePeriodFactor;
    private static boolean timePeriodFactorDefined;

    static {
        timePeriodFactorDefined = false;
    }

    @BeforeClass
    public static void setup() {
        if (System.getProperties().containsKey(RedDeerProperties.TIME_PERIOD_FACTOR.getName())) {
            timePeriodFactor = RedDeerProperties.TIME_PERIOD_FACTOR.getValue();
            timePeriodFactorDefined = true;
        }
    }

    @AfterClass
    public static void cleanup() {
        if (timePeriodFactorDefined) {
            System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), timePeriodFactor);
        } else {
            System.clearProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName());
        }
    }

    @Test
    public void getSeconds_factor1() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "1");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)5L).getSeconds(), (Matcher)CoreMatchers.is((Object)5L));
    }

    @Test
    public void getSeconds_factor1_period0() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "1");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)0L).getSeconds(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void getSeconds_factor1_bignumber() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "1");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)0x7FFFFFFFFFFFFFFDL).getSeconds(), (Matcher)CoreMatchers.is((Object)0x7FFFFFFFFFFFFFFDL));
    }

    @Test
    public void getSeconds_factor1_periodmax() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "1");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)Long.MAX_VALUE).getSeconds(), (Matcher)CoreMatchers.is((Object)Long.MAX_VALUE));
    }

    @Test
    public void getSeconds_factor_gt1() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "2");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)5L).getSeconds(), (Matcher)CoreMatchers.is((Object)10L));
    }

    @Test
    public void getSeconds_factor_gt1_period0() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "2");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)0L).getSeconds(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void getSeconds_factor_gt1_bignumber() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "2");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)0x7FFFFFFFFFFFFFFDL).getSeconds(), (Matcher)CoreMatchers.is((Object)Long.MAX_VALUE));
    }

    @Test
    public void getSeconds_factor_gt1_periodmax() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "2");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)Long.MAX_VALUE).getSeconds(), (Matcher)CoreMatchers.is((Object)Long.MAX_VALUE));
    }

    @Test
    public void getSeconds_factor_lt1() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "0.5");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)5L).getSeconds(), (Matcher)CoreMatchers.is((Object)3L));
    }

    @Test
    public void getSeconds_factor_lt1_period0() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "0.5");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)0L).getSeconds(), (Matcher)CoreMatchers.is((Object)0L));
    }

    @Test
    public void getSeconds_factor_lt1_smallnumber() {
        System.setProperty(RedDeerProperties.TIME_PERIOD_FACTOR.getName(), "0.00005");
        TimePeriod.updateFactor();
        MatcherAssert.assertThat((Object)TimePeriod.getCustom((long)1L).getSeconds(), (Matcher)CoreMatchers.is((Object)0L));
    }
}

