/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.codegen;

import java.util.List;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.reddeer.codegen.builder.ClassBuilder;
import org.eclipse.reddeer.codegen.builder.MethodBuilder;
import org.eclipse.reddeer.codegen.finder.ControlFinder;
import org.eclipse.reddeer.codegen.rules.CodeGenRules;
import org.eclipse.reddeer.codegen.rules.simple.ButtonCodeGenRule;
import org.eclipse.reddeer.codegen.rules.simple.ComboCodeGenRule;
import org.eclipse.reddeer.codegen.rules.simple.ShellCodeGenRule;
import org.eclipse.reddeer.codegen.rules.simple.TextCodeGenRule;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swtbot.generator.framework.GenerationSimpleRule;
import org.eclipse.ui.internal.dialogs.WorkbenchPreferenceDialog;
import org.hamcrest.Matcher;
import org.hamcrest.core.IsInstanceOf;

public class CodeGenerator {
    public static final String WIZARD_DIALOG = "WizardDialog";
    public static final String WIZARD_DIALOG_IMPORT = "org.eclipse.reddeer.jface.wizard.WizardDialog";
    public static final String PREFERENCE_DIALOG = "PreferenceDialog";
    public static final String PREFERENCE_DIALOG_IMPORT = "org.eclipse.reddeer.jface.preference.PreferenceDialog";
    private Shell lastActiveShell;
    private ControlFinder controlFinder = new ControlFinder();
    private ClassBuilder classBuilder = new ClassBuilder();
    private List<String> options;

    public CodeGenerator(String className, String packageName, List<String> optional) {
        this.classBuilder.setClassName(className);
        this.classBuilder.setPackage(packageName);
        this.options = optional;
    }

    public Control getControl() {
        Control[] c = this.lastActiveShell.getChildren();
        Object o = this.lastActiveShell.getData();
        if (!this.options.contains("Include all wizard pages") && !this.options.contains("Allow inheriting (only, if are included all wizard pages)")) {
            if (o instanceof WizardDialog) {
                return ((WizardDialog)o).getCurrentPage().getControl();
            }
            if (o instanceof WorkbenchPreferenceDialog) {
                return ((WorkbenchPreferenceDialog)o).getCurrentPage().getControl();
            }
            return c[0];
        }
        if (this.options.contains("Allow inheriting (only, if are included all wizard pages)")) {
            if (o instanceof WizardDialog) {
                this.classBuilder.setExtendedClass(WIZARD_DIALOG);
            } else if (o instanceof WorkbenchPreferenceDialog) {
                this.classBuilder.setExtendedClass(PREFERENCE_DIALOG);
            }
        }
        return c[0];
    }

    public ClassBuilder generateCode() {
        this.classBuilder.addOptions(this.options);
        this.classBuilder.clearImports();
        List<Control> controls = this.controlFinder.find(this.getControl(), (Matcher<?>)new IsInstanceOf(Control.class));
        controls.add((Control)this.lastActiveShell);
        List<GenerationSimpleRule> simples = new CodeGenRules().createSimpleRules();
        Event e = new Event();
        for (Control control : controls) {
            e.widget = control;
            for (GenerationSimpleRule rule : simples) {
                if (!rule.appliesTo(e)) continue;
                rule.initializeForEvent(e);
                if (rule instanceof ButtonCodeGenRule) {
                    for (MethodBuilder meth : ((ButtonCodeGenRule)rule).getActionMethods(control)) {
                        if (!this.options.contains(meth.getMethodType())) continue;
                        this.classBuilder.addMethod(meth);
                        this.classBuilder.addImports(rule.getImports());
                    }
                    continue;
                }
                if (rule instanceof TextCodeGenRule) {
                    for (MethodBuilder meth : ((TextCodeGenRule)rule).getActionMethods(control)) {
                        if (!this.options.contains(meth.getMethodType())) continue;
                        this.classBuilder.addMethod(meth);
                        this.classBuilder.addImports(rule.getImports());
                    }
                    continue;
                }
                if (rule instanceof ComboCodeGenRule) {
                    for (MethodBuilder meth : ((ComboCodeGenRule)rule).getActionMethods(control)) {
                        if (this.options.contains("Generate static constants")) {
                            this.classBuilder.addConstants(((ComboCodeGenRule)rule).getSelectionList(control));
                        }
                        if (!this.options.contains(meth.getMethodType())) continue;
                        this.classBuilder.addMethod(meth);
                        this.classBuilder.addImports(rule.getImports());
                    }
                    continue;
                }
                if (!(rule instanceof ShellCodeGenRule)) continue;
                for (MethodBuilder meth : ((ShellCodeGenRule)rule).getActionMethods(control)) {
                    if (!this.options.contains(meth.getMethodType())) continue;
                    this.classBuilder.addMethod(meth);
                    this.classBuilder.addImports(rule.getImports());
                }
            }
            if (this.classBuilder.getExtendedClass().equals(WIZARD_DIALOG) && this.classBuilder.isExtendible()) {
                this.classBuilder.addImport(WIZARD_DIALOG_IMPORT);
                continue;
            }
            if (!this.classBuilder.getExtendedClass().equals(PREFERENCE_DIALOG) || !this.classBuilder.isExtendible()) continue;
            this.classBuilder.addImport(PREFERENCE_DIALOG_IMPORT);
        }
        return this.classBuilder;
    }

    public void setLastActiveShell(Shell sh) {
        this.lastActiveShell = sh;
    }
}

