/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.BindingKey;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTRequestor;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ArrayType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.CaptureType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ExtendsWildcardType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.GenericType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.NullType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.ParameterizedType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.PrimitiveType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.RawType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.StandardType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.SuperWildcardType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeTuple;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeVariable;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.UnboundWildcardType;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.VoidType;

public class TypeEnvironment {
    public final PrimitiveType INT = new PrimitiveType(this, 0, BindingKey.createTypeBindingKey((String)"int"));
    public final PrimitiveType CHAR = new PrimitiveType(this, 1, BindingKey.createTypeBindingKey((String)"char"));
    public final PrimitiveType BOOLEAN = new PrimitiveType(this, 2, BindingKey.createTypeBindingKey((String)"boolean"));
    public final PrimitiveType SHORT = new PrimitiveType(this, 3, BindingKey.createTypeBindingKey((String)"short"));
    public final PrimitiveType LONG = new PrimitiveType(this, 4, BindingKey.createTypeBindingKey((String)"long"));
    public final PrimitiveType FLOAT = new PrimitiveType(this, 5, BindingKey.createTypeBindingKey((String)"float"));
    public final PrimitiveType DOUBLE = new PrimitiveType(this, 6, BindingKey.createTypeBindingKey((String)"double"));
    public final PrimitiveType BYTE = new PrimitiveType(this, 7, BindingKey.createTypeBindingKey((String)"byte"));
    public final NullType NULL = new NullType(this);
    public final VoidType VOID = new VoidType(this);
    final PrimitiveType[] PRIMITIVE_TYPES = new PrimitiveType[]{this.INT, this.CHAR, this.BOOLEAN, this.SHORT, this.LONG, this.FLOAT, this.DOUBLE, this.BYTE};
    private static final String[] BOXED_PRIMITIVE_NAMES = new String[]{"java.lang.Integer", "java.lang.Character", "java.lang.Boolean", "java.lang.Short", "java.lang.Long", "java.lang.Float", "java.lang.Double", "java.lang.Byte"};
    private TType OBJECT_TYPE = null;
    private List<Map<TType, ArrayType>> fArrayTypes = new ArrayList<Map<TType, ArrayType>>();
    private Map<IJavaElement, StandardType> fStandardTypes = new HashMap<IJavaElement, StandardType>();
    private Map<IJavaElement, GenericType> fGenericTypes = new HashMap<IJavaElement, GenericType>();
    private Map<ProjectKeyPair, ParameterizedType> fParameterizedTypes = new HashMap<ProjectKeyPair, ParameterizedType>();
    private Map<IJavaElement, RawType> fRawTypes = new HashMap<IJavaElement, RawType>();
    private Map<IJavaElement, TypeVariable> fTypeVariables = new HashMap<IJavaElement, TypeVariable>();
    private Map<ProjectKeyPair, CaptureType> fCaptureTypes = new HashMap<ProjectKeyPair, CaptureType>();
    private Map<TType, ExtendsWildcardType> fExtendsWildcardTypes = new HashMap<TType, ExtendsWildcardType>();
    private Map<TType, SuperWildcardType> fSuperWildcardTypes = new HashMap<TType, SuperWildcardType>();
    private UnboundWildcardType fUnboundWildcardType = null;
    private static final int MAX_ENTRIES = 1024;
    private Map<TypeTuple, Boolean> fSubTypeCache = new LinkedHashMap<TypeTuple, Boolean>(50, 0.75f, true){
        private static final long serialVersionUID = 1L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<TypeTuple, Boolean> eldest) {
            return this.size() > 1024;
        }
    };
    private Map<TType, ArrayList<TType>> fSubTypes;
    private final boolean fRemoveCapures;

    public static ITypeBinding[] createTypeBindings(TType[] types, IJavaProject project) {
        String bindingKey;
        final HashMap<String, TType> mapping = new HashMap<String, TType>();
        ArrayList<String> keys = new ArrayList<String>();
        TType[] tTypeArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            TType type = tTypeArray[n2];
            bindingKey = type.getBindingKey();
            mapping.put(bindingKey, type);
            keys.add(bindingKey);
            ++n2;
        }
        ASTParser parser = ASTParser.newParser((int)16);
        parser.setProject(project);
        parser.setResolveBindings(true);
        parser.createASTs(new ICompilationUnit[0], keys.toArray(new String[keys.size()]), new ASTRequestor(){

            public void acceptBinding(String bindingKey, IBinding binding) {
                mapping.put(bindingKey, binding);
            }
        }, null);
        ITypeBinding[] result = new ITypeBinding[types.length];
        int i = 0;
        while (i < types.length) {
            TType type = types[i];
            bindingKey = type.getBindingKey();
            Object value = mapping.get(bindingKey);
            if (value instanceof ITypeBinding) {
                result[i] = (ITypeBinding)value;
            }
            ++i;
        }
        return result;
    }

    public TypeEnvironment() {
        this(false);
    }

    public TypeEnvironment(boolean rememberSubtypes) {
        this(rememberSubtypes, false);
    }

    public TypeEnvironment(boolean rememberSubtypes, boolean removeCapures) {
        if (rememberSubtypes) {
            this.fSubTypes = new HashMap<TType, ArrayList<TType>>();
        }
        this.fRemoveCapures = removeCapures;
    }

    Map<TypeTuple, Boolean> getSubTypeCache() {
        return this.fSubTypeCache;
    }

    public TType create(ITypeBinding binding) {
        if (binding.isPrimitive()) {
            return this.createPrimitiveType(binding);
        }
        if (binding.isArray()) {
            return this.createArrayType(binding);
        }
        if (binding.isRawType()) {
            return this.createRawType(binding);
        }
        if (binding.isGenericType()) {
            return this.createGenericType(binding);
        }
        if (binding.isParameterizedType()) {
            return this.createParameterizedType(binding);
        }
        if (binding.isTypeVariable()) {
            return this.createTypeVariable(binding);
        }
        if (binding.isWildcardType()) {
            if (binding.getBound() == null) {
                return this.createUnboundWildcardType(binding);
            }
            if (binding.isUpperbound()) {
                return this.createExtendsWildCardType(binding);
            }
            return this.createSuperWildCardType(binding);
        }
        if (binding.isCapture()) {
            if (this.fRemoveCapures) {
                return this.create(binding.getWildcard());
            }
            return this.createCaptureType(binding);
        }
        if ("null".equals(binding.getName())) {
            return this.NULL;
        }
        return this.createStandardType(binding);
    }

    public TType[] create(ITypeBinding[] bindings) {
        TType[] result = new TType[bindings.length];
        int i = 0;
        while (i < bindings.length) {
            result[i] = this.create(bindings[i]);
            ++i;
        }
        return result;
    }

    public TType getJavaLangObject() {
        return this.OBJECT_TYPE;
    }

    public void initializeJavaLangObject(IJavaProject project) {
        if (this.OBJECT_TYPE != null) {
            return;
        }
        StandardType objectType = this.createStandardType("java.lang.Object", project);
        Assert.isTrue((boolean)((TType)objectType).isJavaLangObject());
    }

    void initializeJavaLangObject(ITypeBinding object) {
        if (this.OBJECT_TYPE != null) {
            return;
        }
        StandardType objectType = this.createStandardType(object);
        Assert.isTrue((boolean)((TType)objectType).isJavaLangObject());
    }

    PrimitiveType createUnBoxed(StandardType type) {
        String name = type.getPlainPrettySignature();
        int i = 0;
        while (i < BOXED_PRIMITIVE_NAMES.length) {
            if (BOXED_PRIMITIVE_NAMES[i].equals(name)) {
                return this.PRIMITIVE_TYPES[i];
            }
            ++i;
        }
        return null;
    }

    StandardType createBoxed(PrimitiveType type, IJavaProject focus) {
        String fullyQualifiedName = BOXED_PRIMITIVE_NAMES[type.getId()];
        return this.createStandardType(fullyQualifiedName, focus);
    }

    private StandardType createStandardType(String fullyQualifiedName, IJavaProject focus) {
        try {
            IType javaElementType = focus.findType(fullyQualifiedName);
            StandardType result = this.fStandardTypes.get(javaElementType);
            if (result != null) {
                return result;
            }
            ASTParser parser = ASTParser.newParser((int)16);
            parser.setProject(focus);
            IBinding[] bindings = parser.createBindings(new IJavaElement[]{javaElementType}, null);
            return this.createStandardType((ITypeBinding)bindings[0]);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    Map<TType, ArrayList<TType>> getSubTypes() {
        return this.fSubTypes;
    }

    private void cacheSubType(TType supertype, TType result) {
        ArrayList<TType> subtypes;
        if (this.fSubTypes == null) {
            return;
        }
        if (supertype == null) {
            supertype = this.OBJECT_TYPE;
        }
        if ((subtypes = this.fSubTypes.get(supertype)) == null) {
            subtypes = new ArrayList(5);
            this.fSubTypes.put(supertype, subtypes);
        } else {
            Assert.isTrue((!subtypes.contains(result) ? 1 : 0) != 0);
        }
        subtypes.add(result);
    }

    private void cacheSubTypes(TType[] interfaces, TType result) {
        TType[] tTypeArray = interfaces;
        int n = interfaces.length;
        int n2 = 0;
        while (n2 < n) {
            TType intf = tTypeArray[n2];
            this.cacheSubType(intf, result);
            ++n2;
        }
    }

    private TType createPrimitiveType(ITypeBinding binding) {
        String name = binding.getName();
        String[] names = PrimitiveType.NAMES;
        int i = 0;
        while (i < names.length) {
            if (name.equals(names[i])) {
                return this.PRIMITIVE_TYPES[i];
            }
            ++i;
        }
        Assert.isTrue((boolean)false, (String)("Primitive type " + name + "unkown"));
        return null;
    }

    private ArrayType createArrayType(ITypeBinding binding) {
        int index = binding.getDimensions() - 1;
        TType elementType = this.create(binding.getElementType());
        Map<TType, ArrayType> arrayTypes = this.getArrayTypesMap(index);
        ArrayType result = arrayTypes.get(elementType);
        if (result != null) {
            return result;
        }
        result = new ArrayType(this);
        arrayTypes.put(elementType, result);
        result.initialize(binding, elementType);
        return result;
    }

    public ArrayType createArrayType(TType elementType, int dimensions) {
        Assert.isTrue((!elementType.isArrayType() ? 1 : 0) != 0);
        Assert.isTrue((!elementType.isAnonymous() ? 1 : 0) != 0);
        Assert.isTrue((dimensions > 0 ? 1 : 0) != 0);
        int index = dimensions - 1;
        Map<TType, ArrayType> arrayTypes = this.getArrayTypesMap(index);
        ArrayType result = arrayTypes.get(elementType);
        if (result != null) {
            return result;
        }
        result = new ArrayType(this, BindingKey.createArrayTypeBindingKey((String)elementType.getBindingKey(), (int)dimensions));
        arrayTypes.put(elementType, result);
        result.initialize(elementType, dimensions);
        return result;
    }

    private Map<TType, ArrayType> getArrayTypesMap(int index) {
        Map<TType, ArrayType> arrayTypes;
        int oldLength = this.fArrayTypes.size();
        if (index >= oldLength) {
            this.fArrayTypes.addAll(Collections.nCopies(index + 1 - oldLength, null));
        }
        if ((arrayTypes = this.fArrayTypes.get(index)) == null) {
            arrayTypes = new HashMap<TType, ArrayType>();
            this.fArrayTypes.set(index, arrayTypes);
        }
        return arrayTypes;
    }

    private StandardType createStandardType(ITypeBinding binding) {
        IJavaElement javaElement = binding.getJavaElement();
        StandardType result = this.fStandardTypes.get(javaElement);
        if (result != null) {
            return result;
        }
        result = new StandardType(this);
        this.fStandardTypes.put(javaElement, result);
        result.initialize(binding, (IType)javaElement);
        if (this.OBJECT_TYPE == null && result.isJavaLangObject()) {
            this.OBJECT_TYPE = result;
        }
        return result;
    }

    private GenericType createGenericType(ITypeBinding binding) {
        IJavaElement javaElement = binding.getJavaElement();
        GenericType result = this.fGenericTypes.get(javaElement);
        if (result != null) {
            return result;
        }
        result = new GenericType(this);
        this.fGenericTypes.put(javaElement, result);
        result.initialize(binding, (IType)javaElement);
        this.cacheSubType(result.getSuperclass(), result);
        this.cacheSubTypes(result.getInterfaces(), result);
        return result;
    }

    private ParameterizedType createParameterizedType(ITypeBinding binding) {
        String bindingKey;
        IJavaProject javaProject = binding.getJavaElement().getJavaProject();
        ProjectKeyPair pair = new ProjectKeyPair(javaProject, bindingKey = binding.getKey());
        ParameterizedType result = this.fParameterizedTypes.get(pair);
        if (result != null) {
            return result;
        }
        result = new ParameterizedType(this);
        this.fParameterizedTypes.put(pair, result);
        result.initialize(binding, (IType)binding.getJavaElement());
        this.cacheSubType(result.getSuperclass(), result);
        this.cacheSubTypes(result.getInterfaces(), result);
        return result;
    }

    private RawType createRawType(ITypeBinding binding) {
        IJavaElement javaElement = binding.getJavaElement();
        RawType result = this.fRawTypes.get(javaElement);
        if (result != null) {
            return result;
        }
        result = new RawType(this);
        this.fRawTypes.put(javaElement, result);
        result.initialize(binding, (IType)javaElement);
        this.cacheSubType(result.getSuperclass(), result);
        this.cacheSubTypes(result.getInterfaces(), result);
        return result;
    }

    private TType createUnboundWildcardType(ITypeBinding binding) {
        if (this.fUnboundWildcardType == null) {
            this.fUnboundWildcardType = new UnboundWildcardType(this);
            this.fUnboundWildcardType.initialize(binding);
        }
        return this.fUnboundWildcardType;
    }

    private TType createExtendsWildCardType(ITypeBinding binding) {
        TType bound = this.create(binding.getBound());
        ExtendsWildcardType result = this.fExtendsWildcardTypes.get(bound);
        if (result != null) {
            return result;
        }
        result = new ExtendsWildcardType(this);
        this.fExtendsWildcardTypes.put(bound, result);
        result.initialize(binding);
        return result;
    }

    private TType createSuperWildCardType(ITypeBinding binding) {
        TType bound = this.create(binding.getBound());
        SuperWildcardType result = this.fSuperWildcardTypes.get(bound);
        if (result != null) {
            return result;
        }
        result = new SuperWildcardType(this);
        this.fSuperWildcardTypes.put(bound, result);
        result.initialize(binding);
        return result;
    }

    private TypeVariable createTypeVariable(ITypeBinding binding) {
        IJavaElement javaElement = binding.getJavaElement();
        TypeVariable result = this.fTypeVariables.get(javaElement);
        if (result != null) {
            return result;
        }
        result = new TypeVariable(this);
        this.fTypeVariables.put(javaElement, result);
        result.initialize(binding, (ITypeParameter)javaElement);
        return result;
    }

    private CaptureType createCaptureType(ITypeBinding binding) {
        String bindingKey;
        IJavaProject javaProject = binding.getDeclaringClass().getJavaElement().getJavaProject();
        ProjectKeyPair pair = new ProjectKeyPair(javaProject, bindingKey = binding.getKey());
        CaptureType result = this.fCaptureTypes.get(pair);
        if (result != null) {
            return result;
        }
        result = new CaptureType(this);
        this.fCaptureTypes.put(pair, result);
        result.initialize(binding, javaProject);
        return result;
    }

    private static class ProjectKeyPair {
        private final IJavaProject fProject;
        private final String fBindingKey;

        public ProjectKeyPair(IJavaProject project, String bindingKey) {
            this.fProject = project;
            this.fBindingKey = bindingKey;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ProjectKeyPair)) {
                return false;
            }
            ProjectKeyPair otherPair = (ProjectKeyPair)other;
            return this.fProject.equals(otherPair.fProject) && this.fBindingKey.equals(otherPair.fBindingKey);
        }

        public int hashCode() {
            return this.fProject.hashCode() + this.fBindingKey.hashCode();
        }
    }
}

