/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IDynamicReferenceProvider;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.osgi.service.resolver.BundleDescription;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.BuildDependencyCollector;
import org.eclipse.pde.internal.core.PDECore;

public class DynamicPluginProjectReferences
implements IDynamicReferenceProvider {
    public List<IProject> getDependentProjects(IBuildConfiguration buildConfiguration) throws CoreException {
        BundleDescription currentBundle;
        IPluginModelBase model;
        IProject input = buildConfiguration.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)input);
        if (javaProject != null && (model = PDECore.getDefault().getModelManager().findModel(javaProject.getProject())) != null && (currentBundle = model.getBundleDescription()) != null) {
            IWorkspaceRoot root = PDECore.getWorkspace().getRoot();
            return BuildDependencyCollector.collectBuildRelevantDependencies(Collections.singleton(currentBundle)).stream().filter(dependency -> dependency != currentBundle).map(dependency -> root.getProject(dependency.getName())).filter(IResource::exists).distinct().collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

