/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.server.ui;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.discovery.Discovery;
import org.eclipse.wst.server.ui.ICacheUpdateListener;
import org.eclipse.wst.server.ui.internal.Messages;
import org.eclipse.wst.server.ui.internal.ProgressUtil;
import org.eclipse.wst.server.ui.internal.ServerUIPlugin;

public final class ServerUIUtil {
    public static String refreshButtonText = Messages.cacheUpdate_refreshNow;
    static ICacheUpdateListener cacheUpdateJobListener;

    private ServerUIUtil() {
    }

    public static boolean showNewRuntimeWizard(Shell shell, String typeId, String versionId) {
        return ServerUIPlugin.showNewRuntimeWizard(shell, typeId, versionId, null);
    }

    public static boolean showNewRuntimeWizard(Shell shell, String typeId, String versionId, String runtimeTypeId) {
        return ServerUIPlugin.showNewRuntimeWizard(shell, typeId, versionId, runtimeTypeId);
    }

    public static boolean showNewServerWizard(Shell shell, String typeId, String versionId, String serverTypeId) {
        return ServerUIPlugin.showNewServerWizard(shell, typeId, versionId, serverTypeId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Job refreshServerNode(boolean userInitiated) {
        if (!userInitiated) {
            if (!ServerUIPlugin.getPreferences().getExtAdapter()) {
                return null;
            }
            int cacheFrequency = ServerUIPlugin.getPreferences().getCacheFrequency();
            if (cacheFrequency == 0) {
                return null;
            }
            String dateString = Discovery.getLastUpdatedDate();
            SimpleDateFormat df = new SimpleDateFormat("EEE MMM dd yyyy kk:mm:ss zzz", Locale.ENGLISH);
            try {
                Date lastUpDatedDate = dateString == null || dateString.equals(Messages.cacheUpdate_never) ? new Date(0L) : df.parse(dateString.trim());
                Date currentDate = new Date(System.currentTimeMillis());
                Calendar cal = Calendar.getInstance();
                cal.setTime(lastUpDatedDate);
                switch (cacheFrequency) {
                    case 1: {
                        cal.add(5, 1);
                        if (!cal.getTime().after(currentDate)) break;
                        return null;
                    }
                    case 2: {
                        cal.add(5, 7);
                        if (!cal.getTime().after(currentDate)) break;
                        return null;
                    }
                    case 3: {
                        cal.add(2, 1);
                        if (!cal.getTime().after(currentDate)) break;
                        return null;
                    }
                    case 4: {
                        cal.add(2, 3);
                        if (!cal.getTime().after(currentDate)) break;
                        return null;
                    }
                }
            }
            catch (ParseException parseException) {}
        }
        class RefreshJob
        extends Job {
            public RefreshJob() {
                super(Messages.jobRefreshingServerAdapter);
            }

            public boolean belongsTo(Object family) {
                return "org.eclipse.wst.server.ui.family".equals(family);
            }

            protected IStatus run(IProgressMonitor monitor) {
                monitor = ProgressUtil.getMonitorFor(monitor);
                monitor.beginTask("", 1000);
                refreshButtonText = Messages.cacheUpdate_refreshing;
                if (cacheUpdateJobListener != null) {
                    cacheUpdateJobListener.start();
                }
                Discovery.refreshServerAdapters((IProgressMonitor)ProgressUtil.getSubMonitorFor(monitor, 500));
                monitor.worked(700);
                refreshButtonText = Messages.cacheUpdate_refreshNow;
                if (cacheUpdateJobListener != null) {
                    cacheUpdateJobListener.done();
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                ServerCore.resetDownloadableServers();
                monitor.worked(900);
                return Status.OK_STATUS;
            }
        }
        RefreshJob job = new RefreshJob();
        job.schedule();
        job.setPriority(20);
        return job;
    }

    public static void setListener(ICacheUpdateListener listener) {
        cacheUpdateJobListener = listener;
    }
}

