/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.reddeer.junit.test.execution;

import java.util.LinkedList;
import org.eclipse.reddeer.junit.internal.runner.ParameterizedRequirementsRunnerFactory;
import org.eclipse.reddeer.junit.runner.RedDeerSuite;
import org.eclipse.reddeer.junit.test.integration.runner.IAfterTestImpl;
import org.eclipse.reddeer.junit.test.integration.runner.IBeforeTestImpl;
import org.eclipse.reddeer.junit.test.integration.runner.order.TestSequence;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=RedDeerSuite.class)
@Parameterized.UseParametersRunnerFactory(value=ParameterizedRequirementsRunnerFactory.class)
public class ParameterizedConstructorTest {
    private String param;
    private static final String[] PARAMS = new String[]{"param0", "param1"};
    private static final LinkedList<Object> expectedSequence = new LinkedList();

    static {
        expectedSequence.addLast(TestSequence.createBeforeClass(ParameterizedConstructorTest.class));
        expectedSequence.addLast(TestSequence.constructTestWithParam(ParameterizedConstructorTest.class, ParameterizedConstructorTest.params()[0]));
        expectedSequence.addLast(TestSequence.createIBefore(IBeforeTestImpl.class));
        expectedSequence.addLast(TestSequence.createBefore(ParameterizedConstructorTest.class));
        expectedSequence.addLast(TestSequence.createTestWithParam(ParameterizedConstructorTest.class, ParameterizedConstructorTest.params()[0]));
        expectedSequence.addLast(TestSequence.createAfter(ParameterizedConstructorTest.class));
        expectedSequence.addLast(TestSequence.createIAfter(IAfterTestImpl.class));
        expectedSequence.addLast(TestSequence.constructTestWithParam(ParameterizedConstructorTest.class, ParameterizedConstructorTest.params()[1]));
        expectedSequence.addLast(TestSequence.createIBefore(IBeforeTestImpl.class));
        expectedSequence.addLast(TestSequence.createBefore(ParameterizedConstructorTest.class));
        expectedSequence.addLast(TestSequence.createTestWithParam(ParameterizedConstructorTest.class, ParameterizedConstructorTest.params()[1]));
        expectedSequence.addLast(TestSequence.createAfter(ParameterizedConstructorTest.class));
        expectedSequence.addLast(TestSequence.createIAfter(IAfterTestImpl.class));
        expectedSequence.addLast(TestSequence.createAfterClass(ParameterizedConstructorTest.class));
    }

    @Parameterized.Parameters(name="param: {0}")
    public static String[] params() {
        return PARAMS;
    }

    public ParameterizedConstructorTest(String param) {
        this.param = param;
        TestSequence.addConstructTestWithParam(ParameterizedConstructorTest.class, this.param);
    }

    @BeforeClass
    public static void beforeClass() {
        TestSequence.getRealSequence().clear();
        TestSequence.addBeforeClass(ParameterizedConstructorTest.class);
    }

    @Before
    public void before() {
        TestSequence.addBefore(ParameterizedConstructorTest.class);
    }

    @Test
    public void test() {
        TestSequence.addTestWithParam(ParameterizedConstructorTest.class, this.param);
    }

    @After
    public void after() {
        TestSequence.addAfter(ParameterizedConstructorTest.class);
    }

    @AfterClass
    public static void afterClass() {
        TestSequence.addAfterClass(ParameterizedConstructorTest.class);
        String sequenceDiff = TestSequence.diffRealSequence(expectedSequence);
        TestSequence.getRealSequence().clear();
        Assert.assertTrue((String)("Test sequence is different than expected. " + sequenceDiff), (sequenceDiff == null ? 1 : 0) != 0);
    }
}

